/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.otp;

import com.ericsson.lwac.ErrorCode;

public enum OtpErrorCode implements ErrorCode
{
    OTP_UNKNOWN_FINGERPRINT_VERSION(86001, "Unknown fingerprint version %d", 1),
    OTP_VALIDATION_ERROR(86002, "Validation error: %s", 1),
    OTP_GENERATION_RATE_LIMIT_EXCEEDED(86003, "Operation not allowed, too fast OTP generation. Please wait at least %d minutes and try again.", 1),
    OTP_GENERATION_FAILURE_COUNTER_EXCEEDED(86004, "Operation not allowed, too many faulty OTPs. It might work after %d minutes.", 1),
    OTP_INVALID(86005, "Invalid otp", 0),
    OTP_NOT_FOUND(86006, "Otp not found", 0),
    INCORRECT_SECURITY_ANSWERS(86007, "Security answers were not correct", 0);

    private final int id;
    private final String message;
    private final int numOfArguments;
    private static final int ERRORGROUP = 86;

    private OtpErrorCode(int id, String message, int numOfArgs) {
        this.id = id;
        this.message = message;
        this.numOfArguments = numOfArgs;
    }

    @Override
    public int getErrorCode() {
        return this.id % 1000;
    }

    @Override
    public int getErrorGroup() {
        return 86;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getNumOfArgs() {
        return this.numOfArguments;
    }

    @Override
    public String getName() {
        return this.toString();
    }
}

