/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.otp;

import com.ericsson.em.emc.operations.otp.OtpOperations;
import com.ericsson.em.emc.otp.persistence.Otp;
import java.io.Serializable;

final class OtpHistoryKey
implements Serializable {
    private final String identification;
    private final OtpOperations operationType;

    OtpHistoryKey(String identification, OtpOperations operationType) {
        this.identification = identification;
        this.operationType = operationType;
    }

    String getIdentification() {
        return this.identification;
    }

    OtpOperations getOperationType() {
        return this.operationType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OtpHistoryKey) {
            OtpHistoryKey pair = (OtpHistoryKey)obj;
            if (this.identification != null ? !this.identification.equals(pair.identification) : pair.identification != null) {
                return false;
            }
            return !(this.operationType != null ? !this.operationType.equals((Object)pair.operationType) : pair.operationType != null);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identification == null ? 0 : this.identification.hashCode());
        result = 31 * result + (this.operationType == null ? 0 : this.operationType.hashCode());
        return result;
    }

    public static OtpHistoryKey valueOf(String identification, OtpOperations operationType) {
        return new OtpHistoryKey(identification, operationType);
    }

    public static OtpHistoryKey fromOtp(Otp otp) {
        return new OtpHistoryKey(otp.getIdentification(), otp.getOperationType());
    }

    public String toStringKey() {
        return this.identification + ":" + this.operationType.ordinal();
    }
}

