/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.password;

import com.ericsson.em.emc.CoreUserErrorCode;
import com.ericsson.em.emc.UserExceptionBuilder;
import com.ericsson.em.emc.credential.CredentialManager;
import com.ericsson.em.emc.credential.CredentialOwner;
import com.ericsson.em.emc.credential.hash.HashManager;
import com.ericsson.em.emc.credential.persistence.Credential;
import com.ericsson.em.emc.credential.persistence.CredentialHistory;
import com.ericsson.em.emc.credential.persistence.CredentialHistoryDAO;
import com.ericsson.em.emc.credential.persistence.CredentialType;
import com.ericsson.em.emc.password.PasswordService;
import com.ericsson.lwac.deployer.service.Service;
import com.ericsson.lwac.security.HashVersion;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Service
public class PasswordServiceBean
implements PasswordService {
    private static final String SPECIAL_CHARACTERS_FOR_PASSWORD_GENERATION = ".,()!?/+*=@_-";
    private static final String SPECIAL_CHARACTERS_PATTERN = ".,()!?/+*=@_-".replace("+", "\\+").replace("-", "\\-");
    private static final String LOWER_CASE_ALPHA = "abcdefghijklmnopqrstuvwxyz";
    private static final String UPPER_CASE_ALPHA = "abcdefghijklmnopqrstuvwxyz".toUpperCase();
    private static final String ALL_ALPHA = "abcdefghijklmnopqrstuvwxyz" + UPPER_CASE_ALPHA;
    @EJB
    private CredentialManager credentialManager;
    @EJB
    private CredentialHistoryDAO credentialHistoryDAO;
    @EJB
    private HashManager hashManager;
    private static final int NOT_DEFINED = -1;
    private static final int MAX_VALUE = 32;
    private static final int NUM_OF_SUB_RULES = 5;
    private int minPasswordLen = -1;
    private int maxNumOfIdenticalConsecutiveChars = -1;
    private int maxNumOfPreviousPasswordsToMatch = -1;
    private int minNumOfSubRulesToBeFulfilled = -1;
    private int subRuleMinNumOfUpperCaseOrLowercaseAlphaChars = -1;
    private int subRuleMinNumOfLowercaseAlphaChars = -1;
    private int subRuleMinNumOfUppercaseAlphaChars = -1;
    private int subRuleMinNumOfNumericDigits = -1;
    private int subRuleMinNumOfSpecialChars = -1;
    private Pattern specialCharsPattern;
    private PasswordService.NotificationChannel notificationChannel = PasswordService.NotificationChannel.SMS;

    @PostConstruct
    public void postConstruct() {
        this.validateProperties();
        this.compilePatterns();
    }

    @Override
    public void setMinimumPasswordLength(int value) {
        this.minPasswordLen = value;
    }

    @Override
    public void setMaximumNumberOfIdenticalConsecutiveCharacters(int value) {
        this.maxNumOfIdenticalConsecutiveChars = value;
    }

    @Override
    public void setMaximumNumberOfPreviousPasswordsToMatch(int value) {
        this.maxNumOfPreviousPasswordsToMatch = value;
    }

    @Override
    public void setMinimumNumberOfSubRulesToBeFulfilled(int value) {
        this.minNumOfSubRulesToBeFulfilled = value;
    }

    @Override
    public void setSubRuleMinimumNumberOfUpperCaseOrLowercaseAlphabeticCharacters(int value) {
        this.subRuleMinNumOfUpperCaseOrLowercaseAlphaChars = value;
    }

    @Override
    public void setSubRuleMinimumNumberOfLowercaseAlphabeticCharacters(int value) {
        this.subRuleMinNumOfLowercaseAlphaChars = value;
    }

    @Override
    public void setSubRuleMinimumNumberOfUpperCaseAlphabeticCharacters(int value) {
        this.subRuleMinNumOfUppercaseAlphaChars = value;
    }

    @Override
    public void setSubRuleMinimumNumberOfNumericalDigits(int value) {
        this.subRuleMinNumOfNumericDigits = value;
    }

    @Override
    public void setSubRuleMinimumNumberOfSpecialCharacters(int value) {
        this.subRuleMinNumOfSpecialChars = value;
    }

    @Override
    public void validatePassword(CredentialOwner credentialOwner, String firstName, String surName, String password) {
        this.validatePasswordStrength(password);
        if (credentialOwner != null && credentialOwner.getUsername() != null) {
            this.checkUserIdInPassword(credentialOwner.getUsername(), password);
        }
        if (firstName != null) {
            this.checkFirstNameInPassword(firstName, password);
        }
        if (surName != null) {
            this.checkSurnameInPassword(surName, password);
        }
        if (credentialOwner != null) {
            this.checkPasswordHistory(credentialOwner, password);
        }
    }

    @Override
    public void validatePasswordStrength(String password) {
        if (password == null) {
            throw new UserExceptionBuilder(CoreUserErrorCode.PASSWORD_TOO_SHORT).add("min", this.minPasswordLen).create();
        }
        CharsetEncoder asciiEncoder = StandardCharsets.US_ASCII.newEncoder();
        if (!asciiEncoder.canEncode(password)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.NONASCII_CHARACTERS_IN_PASSWORD).create();
        }
        this.checkPasswordLength(password);
        this.checkIdenticalConsecutiveCharactersInPassword(password);
        this.checkSubRules(password);
    }

    private void checkUserIdInPassword(String userId, String password) {
        String uid = userId.toLowerCase();
        String pwd = password.toLowerCase();
        if (pwd.contains(uid)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.USER_ID_NOT_ALLOWED_IN_PASSWORD).create();
        }
        StringBuffer buffer = new StringBuffer(uid);
        String reversedUserId = (buffer = buffer.reverse()).toString();
        if (pwd.contains(reversedUserId)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.REVERSED_USER_ID_NOT_ALLOWED_IN_PASSWORD).create();
        }
    }

    private void checkFirstNameInPassword(String firstName, String password) {
        String pwd = password.toLowerCase();
        if (!firstName.isEmpty() && pwd.contains(firstName.toLowerCase())) {
            throw new UserExceptionBuilder(CoreUserErrorCode.FIRST_NAME_NOT_ALLOWED_IN_PASSWORD).create();
        }
    }

    private void checkSurnameInPassword(String surname, String password) {
        String pwd = password.toLowerCase();
        if (!surname.isEmpty() && pwd.contains(surname.toLowerCase())) {
            throw new UserExceptionBuilder(CoreUserErrorCode.SURNAME_NOT_ALLOWED_IN_PASSWORD).create();
        }
    }

    private void checkPasswordLength(String password) {
        if (this.minPasswordLen > 0 && password.length() < this.minPasswordLen) {
            throw new UserExceptionBuilder(CoreUserErrorCode.PASSWORD_TOO_SHORT).add("min", this.minPasswordLen).create();
        }
    }

    private void checkIdenticalConsecutiveCharactersInPassword(String password) {
        if (!this.verifyIdenticalConsecutiveCharactersInPassword(password)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.TOO_MANY_IDENTICAL_CONSECUTIVE_CHARACTERS_IN_PASSWORD).add("max", this.maxNumOfIdenticalConsecutiveChars).create();
        }
    }

    private boolean verifyIdenticalConsecutiveCharactersInPassword(String password) {
        if (this.maxNumOfIdenticalConsecutiveChars > 0) {
            int len = password.length();
            for (int i = 0; i < len; ++i) {
                char c = password.charAt(i);
                int n = 1;
                for (int j = i + 1; j < len && password.charAt(j) == c; ++j) {
                    if (++n <= this.maxNumOfIdenticalConsecutiveChars) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void checkPasswordHistory(CredentialOwner credentialOwner, String password) {
        Long saltId = credentialOwner.getCredentialOwnerReference().getId();
        HashMap<HashVersion, byte[]> differentVersionHashes = new HashMap<HashVersion, byte[]>();
        if (this.maxNumOfPreviousPasswordsToMatch > 0) {
            Credential credential = this.credentialManager.getCredentialByOwnerAndCredentialType(credentialOwner, "password");
            if (credential == null) {
                return;
            }
            byte[] hashedPassword = this.getCredentialHashForHashVersion(saltId, password, credential.getHashVersion(), differentVersionHashes);
            if (Arrays.equals(hashedPassword, credential.getHashedCredential())) {
                throw new UserExceptionBuilder(CoreUserErrorCode.PASSWORD_ALREADY_USED_BEFORE).create();
            }
            if (this.maxNumOfPreviousPasswordsToMatch > 1) {
                CredentialType credentialType = this.credentialManager.getCredentialType("password");
                List<CredentialHistory> history = this.credentialHistoryDAO.findLatestByCredentialOwnerAndCredentialType(credentialOwner, credentialType, this.maxNumOfPreviousPasswordsToMatch - 1);
                for (CredentialHistory ch : history) {
                    hashedPassword = this.getCredentialHashForHashVersion(saltId, password, ch.getHashVersion(), differentVersionHashes);
                    if (!Arrays.equals(hashedPassword, ch.getHashedPassword())) continue;
                    throw new UserExceptionBuilder(CoreUserErrorCode.PASSWORD_ALREADY_USED_BEFORE).create();
                }
            }
        }
    }

    private byte[] getCredentialHashForHashVersion(Long databaseId, String credential, HashVersion hashVersion, Map<HashVersion, byte[]> map) {
        byte[] hash = map.get((Object)hashVersion);
        if (hash == null) {
            hash = this.hashManager.getHashedCredential(databaseId, credential, hashVersion);
            map.put(hashVersion, hash);
        }
        return hash;
    }

    private void checkSubRules(String password) {
        if (this.minNumOfSubRulesToBeFulfilled > 0) {
            boolean isMinNumOfUpperCaseOrLowercaseAlphaCharsValid = false;
            boolean isMinNumOfLowerCaseAlphaChars = false;
            boolean isMinNumOfUpperCaseAlphaChars = false;
            boolean isMinNumOfNumericDigits = false;
            boolean isMinNumOfSpecialChars = false;
            int numOfFulfilledSubRules = 0;
            int numOfCharacters = password.length();
            int numOfLowerCase = 0;
            int numOfUpperCase = 0;
            int numOfDigits = 0;
            for (int i = 0; i < numOfCharacters; ++i) {
                char c = password.charAt(i);
                if (c >= 'A' && c <= 'Z') {
                    ++numOfUpperCase;
                    continue;
                }
                if (c >= 'a' && c <= 'z') {
                    ++numOfLowerCase;
                    continue;
                }
                if (c < '0' || c > '9') continue;
                ++numOfDigits;
            }
            if (this.subRuleMinNumOfUpperCaseOrLowercaseAlphaChars != -1 && numOfLowerCase + numOfUpperCase >= this.subRuleMinNumOfUpperCaseOrLowercaseAlphaChars) {
                isMinNumOfUpperCaseOrLowercaseAlphaCharsValid = true;
                ++numOfFulfilledSubRules;
            }
            if (this.subRuleMinNumOfLowercaseAlphaChars != -1 && numOfLowerCase >= this.subRuleMinNumOfLowercaseAlphaChars) {
                isMinNumOfLowerCaseAlphaChars = true;
                ++numOfFulfilledSubRules;
            }
            if (this.subRuleMinNumOfUppercaseAlphaChars != -1 && numOfUpperCase >= this.subRuleMinNumOfUppercaseAlphaChars) {
                isMinNumOfUpperCaseAlphaChars = true;
                ++numOfFulfilledSubRules;
            }
            if (this.subRuleMinNumOfNumericDigits != -1 && numOfDigits >= this.subRuleMinNumOfNumericDigits) {
                isMinNumOfNumericDigits = true;
                ++numOfFulfilledSubRules;
            }
            if (this.subRuleMinNumOfSpecialChars != -1) {
                int numOfSpecial = 0;
                Matcher m = this.specialCharsPattern.matcher(password);
                while (m.find()) {
                    ++numOfSpecial;
                }
                if (numOfSpecial >= this.subRuleMinNumOfSpecialChars) {
                    isMinNumOfSpecialChars = true;
                    ++numOfFulfilledSubRules;
                }
            }
            if (numOfFulfilledSubRules < this.minNumOfSubRulesToBeFulfilled) {
                if (this.subRuleMinNumOfUpperCaseOrLowercaseAlphaChars != -1 && !isMinNumOfUpperCaseOrLowercaseAlphaCharsValid) {
                    throw new UserExceptionBuilder(CoreUserErrorCode.TOO_FEW_UPPERCASE_OR_LOWERCASE_ALPHABETIC_CHARACTERS_IN_PASSWORD).add("min", this.subRuleMinNumOfUpperCaseOrLowercaseAlphaChars).create();
                }
                if (this.subRuleMinNumOfLowercaseAlphaChars != -1 && !isMinNumOfLowerCaseAlphaChars) {
                    throw new UserExceptionBuilder(CoreUserErrorCode.TOO_FEW_LOWERCASE_ALPHABETIC_CHARACTERS_IN_PASSWORD).add("min", this.subRuleMinNumOfLowercaseAlphaChars).create();
                }
                if (this.subRuleMinNumOfUppercaseAlphaChars != -1 && !isMinNumOfUpperCaseAlphaChars) {
                    throw new UserExceptionBuilder(CoreUserErrorCode.TOO_FEW_UPPERCASE_ALPHABETIC_CHARACTERS_IN_PASSWORD).add("min", this.subRuleMinNumOfUppercaseAlphaChars).create();
                }
                if (this.subRuleMinNumOfNumericDigits != -1 && !isMinNumOfNumericDigits) {
                    throw new UserExceptionBuilder(CoreUserErrorCode.TOO_FEW_NUMERICAL_DIGITS_IN_PASSWORD).add("min", this.subRuleMinNumOfNumericDigits).create();
                }
                if (this.subRuleMinNumOfSpecialChars != -1 && !isMinNumOfSpecialChars) {
                    throw new UserExceptionBuilder(CoreUserErrorCode.TOO_FEW_SPECIAL_CHARACTERS_IN_PASSWORD).add("min", this.subRuleMinNumOfSpecialChars).create();
                }
                throw new UserExceptionBuilder(CoreUserErrorCode.REQUIRED_PASSWORD_CRITERIA_NOT_MATCH).create();
            }
        }
    }

    @Override
    public void validateProperties() {
        if (this.minPasswordLen != -1 && (this.minPasswordLen < 0 || this.minPasswordLen > 32)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.REQUIRED_PASSWORD_CRITERIA_NOT_MATCH).create();
        }
        if (this.maxNumOfIdenticalConsecutiveChars != -1 && (this.maxNumOfIdenticalConsecutiveChars < 0 || this.maxNumOfIdenticalConsecutiveChars > 32)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.REQUIRED_PASSWORD_CRITERIA_NOT_MATCH).create();
        }
        if (this.maxNumOfPreviousPasswordsToMatch != -1 && (this.maxNumOfPreviousPasswordsToMatch < 0 || this.maxNumOfPreviousPasswordsToMatch > 32)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.REQUIRED_PASSWORD_CRITERIA_NOT_MATCH).create();
        }
        if (this.minNumOfSubRulesToBeFulfilled != -1 && (this.minNumOfSubRulesToBeFulfilled < 0 || this.minNumOfSubRulesToBeFulfilled > 5)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.REQUIRED_PASSWORD_CRITERIA_NOT_MATCH).create();
        }
        if (this.subRuleMinNumOfUpperCaseOrLowercaseAlphaChars != -1 && (this.subRuleMinNumOfUpperCaseOrLowercaseAlphaChars < 0 || this.subRuleMinNumOfUpperCaseOrLowercaseAlphaChars > 32)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.REQUIRED_PASSWORD_CRITERIA_NOT_MATCH).create();
        }
        if (this.subRuleMinNumOfLowercaseAlphaChars != -1 && (this.subRuleMinNumOfLowercaseAlphaChars < 0 || this.subRuleMinNumOfLowercaseAlphaChars > 32)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.REQUIRED_PASSWORD_CRITERIA_NOT_MATCH).create();
        }
        if (this.subRuleMinNumOfUppercaseAlphaChars != -1 && (this.subRuleMinNumOfUppercaseAlphaChars < 0 || this.subRuleMinNumOfUppercaseAlphaChars > 32)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.REQUIRED_PASSWORD_CRITERIA_NOT_MATCH).create();
        }
        if (this.subRuleMinNumOfNumericDigits != -1 && (this.subRuleMinNumOfNumericDigits < 0 || this.subRuleMinNumOfNumericDigits > 32)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.REQUIRED_PASSWORD_CRITERIA_NOT_MATCH).create();
        }
        if (this.subRuleMinNumOfSpecialChars != -1 && (this.subRuleMinNumOfSpecialChars < 0 || this.subRuleMinNumOfSpecialChars > 32)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.REQUIRED_PASSWORD_CRITERIA_NOT_MATCH).create();
        }
        if (this.minNumOfSubRulesToBeFulfilled != -1) {
            int numOfUsedSubRules = 0;
            numOfUsedSubRules += this.subRuleMinNumOfUpperCaseOrLowercaseAlphaChars == -1 ? 0 : 1;
            numOfUsedSubRules += this.subRuleMinNumOfLowercaseAlphaChars == -1 ? 0 : 1;
            numOfUsedSubRules += this.subRuleMinNumOfUppercaseAlphaChars == -1 ? 0 : 1;
            numOfUsedSubRules += this.subRuleMinNumOfNumericDigits == -1 ? 0 : 1;
            if (this.minNumOfSubRulesToBeFulfilled > (numOfUsedSubRules += this.subRuleMinNumOfSpecialChars == -1 ? 0 : 1)) {
                throw new UserExceptionBuilder(CoreUserErrorCode.REQUIRED_PASSWORD_CRITERIA_NOT_MATCH).create();
            }
        }
    }

    private void compilePatterns() {
        this.specialCharsPattern = Pattern.compile("([" + SPECIAL_CHARACTERS_PATTERN + "])");
    }

    @Override
    public String generateRandomPassword() {
        for (int k = 0; k < 10; ++k) {
            int i;
            SecureRandom random = new SecureRandom();
            StringBuilder builder = new StringBuilder();
            for (i = 0; i < this.subRuleMinNumOfLowercaseAlphaChars; ++i) {
                builder.append(PasswordServiceBean.randomChar(LOWER_CASE_ALPHA, random));
            }
            for (i = 0; i < this.subRuleMinNumOfUppercaseAlphaChars; ++i) {
                builder.append(PasswordServiceBean.randomChar(UPPER_CASE_ALPHA, random));
            }
            for (i = 0; i < this.subRuleMinNumOfNumericDigits; ++i) {
                builder.append(random.nextInt(10));
            }
            for (i = 0; i < this.subRuleMinNumOfSpecialChars; ++i) {
                builder.append(PasswordServiceBean.randomChar(SPECIAL_CHARACTERS_FOR_PASSWORD_GENERATION, random));
            }
            for (i = 0; i < this.subRuleMinNumOfUpperCaseOrLowercaseAlphaChars; ++i) {
                builder.append(PasswordServiceBean.randomChar(ALL_ALPHA, random));
            }
            int diff = this.minPasswordLen - builder.length();
            for (int i2 = 0; i2 < diff; ++i2) {
                builder.append(PasswordServiceBean.randomChar(ALL_ALPHA, random));
            }
            String password = PasswordServiceBean.permutate(builder);
            if (!this.verifyIdenticalConsecutiveCharactersInPassword(password)) continue;
            return password;
        }
        throw new IllegalArgumentException("Password could not be generated");
    }

    private static char randomChar(String string, SecureRandom random) {
        return string.charAt(random.nextInt(string.length()));
    }

    protected static String permutate(StringBuilder builder) {
        SecureRandom random = new SecureRandom();
        int length = builder.length();
        for (int i = 0; i < length; ++i) {
            int swapIndex = random.nextInt(length);
            char temp = builder.charAt(i);
            builder.setCharAt(i, builder.charAt(swapIndex));
            builder.setCharAt(swapIndex, temp);
        }
        return builder.toString();
    }

    public void setNotificationChannel(String channel) {
        try {
            this.notificationChannel = PasswordService.NotificationChannel.valueOf(channel);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Illegal channel, allowed values are: " + this.formatAllowedChannels(), e);
        }
    }

    private String formatAllowedChannels() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (PasswordService.NotificationChannel channel : PasswordService.NotificationChannel.values()) {
            builder.append(channel.name());
            if (++i >= PasswordService.NotificationChannel.values().length) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    @Override
    public PasswordService.NotificationChannel getNotificationChannel() {
        return this.notificationChannel;
    }

    @Override
    public void setNotificationChannelString(String channel) {
        this.setNotificationChannel(channel);
    }
}

