/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.persistance;

import com.ericsson.em.emc.persistance.ViewProcessor;
import com.ericsson.em.emc.util.Money;
import com.ericsson.lwac.database.persistence.ExtendedBaseEntityDAOBean;
import jakarta.annotation.Resource;
import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.joda.time.DateTime;

public abstract class AbstractReadOnlyDAOBean<ReadOnlyEntity> {
    @Resource
    private DataSource dataSource;

    protected long processResultSet(ViewProcessor<ReadOnlyEntity> processor, Object ... parameters) throws Exception {
        long n = 0L;
        String statement = this.getSelectStatement();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(statement);){
            this.assignParameters(preparedStatement, parameters);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    ReadOnlyEntity entity = this.processEachResultSetObject(resultSet);
                    processor.processResult(entity);
                    ++n;
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException(String.format("Error while executing: %s parameters %s", statement, this.toString(parameters)), e);
        }
        return n;
    }

    protected abstract String getSelectStatement();

    protected abstract ReadOnlyEntity processEachResultSetObject(ResultSet var1) throws SQLException;

    private void assignParameters(PreparedStatement preparedStatement, Object ... parameters) throws SQLException {
        int i = 1;
        for (Object parameter : parameters) {
            if (parameter instanceof Long) {
                preparedStatement.setLong(i++, (Long)parameter);
                continue;
            }
            if (parameter instanceof Integer) {
                preparedStatement.setInt(i++, (Integer)parameter);
                continue;
            }
            if (parameter instanceof String) {
                preparedStatement.setString(i++, (String)parameter);
                continue;
            }
            if (parameter instanceof Timestamp) {
                preparedStatement.setTimestamp(i++, (Timestamp)parameter);
                continue;
            }
            if (parameter instanceof Enum) {
                preparedStatement.setInt(i++, ((Enum)parameter).ordinal());
                continue;
            }
            if (parameter instanceof Money) {
                preparedStatement.setBigDecimal(i++, ((Money)parameter).toBigDecimal());
                continue;
            }
            if (parameter instanceof byte[]) {
                preparedStatement.setBytes(i++, (byte[])parameter);
                continue;
            }
            if (parameter instanceof DateTime) {
                preparedStatement.setObject(i++, (Object)ExtendedBaseEntityDAOBean.getTimestamp((DateTime)((DateTime)parameter)), 93, 9);
                continue;
            }
            if (parameter == null) {
                preparedStatement.setNull(i++, 0);
                continue;
            }
            throw new UnsupportedOperationException();
        }
    }

    private String toString(Object ... parameters) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < parameters.length; ++i) {
            result.append(parameters[i]).append(i + 1 < parameters.length ? ", " : "");
        }
        return result.toString();
    }
}

