/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.profile;

import com.ericsson.em.emc.accountholder.ProtectedIdentityClassificationValue;
import com.ericsson.em.emc.util.MoneyHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public enum PermissionWithProperty {
    DEFAULT("maxLevelInHierarchy", PermissionWithProperty::isNonNegativeInteger),
    ROLE_FLOAT_TRANSFER_IN_OWN_ASCENDING_LINE("maxLevelsUpInHierarchy", PermissionWithProperty::isPositiveInteger),
    ROLE_FLOAT_TRANSFER_IN_OWN_DESCENDING_LINE("maxLevelsDownInHierarchy", PermissionWithProperty::isPositiveInteger),
    ROLE_FLOAT_TRANSFER_WITHIN_OWN_SUB_HIERARCHY("subHierarchyStartingLevel", PermissionWithProperty::isPositiveInteger),
    ROLE_APPROVAL_ON_REVERSE_TRANSACTION("ApprovalLimits", PermissionWithProperty::isApprovalLimit),
    ROLE_VIEW_ANY_PROTECTED_IDENTITY_ACCOUNT_HOLDER("AllowedProtectedIdentityCategories", PermissionWithProperty::validateProtectedIdentityProperty, true);

    private final String property;
    private final Function<String, Boolean> validator;
    private final boolean areMultipleValuesAllowed;
    private static final String DELIMITER = ":";
    public static final String MULTIPLE_VALUE_DELIMITER = ",";

    private PermissionWithProperty(String property, Function<String, Boolean> validator) {
        this.property = property;
        this.validator = validator;
        this.areMultipleValuesAllowed = false;
    }

    private PermissionWithProperty(String property, Function<String, Boolean> validator, boolean areMultipleValuesAllowed) {
        this.property = property;
        this.validator = validator;
        this.areMultipleValuesAllowed = areMultipleValuesAllowed;
    }

    public static PermissionWithProperty fromPermission(String permission) {
        for (PermissionWithProperty p : PermissionWithProperty.values()) {
            if (!Objects.equals(p.name(), permission)) continue;
            return p;
        }
        return DEFAULT;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean isValid(String value) {
        return this.validator.apply(value);
    }

    public boolean areMultipleValuesAllowed() {
        return this.areMultipleValuesAllowed;
    }

    private static boolean isNonNegativeInteger(String value) {
        try {
            return Integer.parseInt(value) >= 0;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    private static boolean isPositiveInteger(String value) {
        try {
            return Integer.parseInt(value) > 0;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    private static boolean validateProtectedIdentityProperty(String value) {
        List<String> propertyValues = Arrays.asList(value.split(MULTIPLE_VALUE_DELIMITER));
        if (propertyValues.stream().map(String::trim).distinct().count() != (long)propertyValues.size()) {
            return false;
        }
        return propertyValues.stream().allMatch(PermissionWithProperty::isAValidProtectedIdentity);
    }

    private static boolean isAValidProtectedIdentity(String value) {
        try {
            return Arrays.stream(ProtectedIdentityClassificationValue.values()).anyMatch(category -> Integer.parseInt(category.getProtectedIdentityClassificationType()) == Integer.parseInt(value.trim()));
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    private static Boolean isApprovalLimit(String value) {
        try {
            return !MoneyHelper.convertStringToMonies(value, DELIMITER).isEmpty();
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

