/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.profile;

import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeBasedAccessValidator {
    private static final Logger logger = LoggerFactory.getLogger(TimeBasedAccessValidator.class);
    private static final int MAX_NANO_SECONDS = 999999999;
    private static final int MAX_SECONDS = 59;
    private static final int NOT_FOUND = -1;
    private static final int DAYS_IN_WEEK = 7;
    private static final int ONE_INDEX_DELTA = 1;
    private static final int FULL_MINUTES_IN_DAY = 1439;
    private static final int SUM_OF_DAYS = 28;
    public static final String TIME_BASED_ACCESS_ENABLED = "Time Based Access Enabled";
    public static final String TIME_BASED_ACCESS_WEEK_DAYS = "Time Based Access Week Days";
    public static final String TIME_BASED_ACCESS_START_TIME = "Time Based Access Start Time";
    public static final String TIME_BASED_ACCESS_END_TIME = "Time Based Access End Time";
    public static final String TIME_BASED_ACCESS_DENIED = "Access denied since current time is not within allowed access time";
    public static final String KEY_NEXT_SESSION_START_TIME = "nextSessionStartTime";

    private TimeBasedAccessValidator() {
        throw new UnsupportedOperationException();
    }

    public static LocalDateTime getNextSessionEndTime(Profile profile) {
        return TimeBasedAccessValidator.getNextSessionEndTime(profile, LocalDateTime.now());
    }

    public static LocalDateTime getNextSessionStartTime(Profile profile, LocalDateTime now) {
        if (profile != null) {
            OptionalInt nextAllowedWeekDay;
            Optional<ProfileService> optionalProfileService = profile.getServices().stream().filter(ps -> "true".equalsIgnoreCase(ps.getPropertyValue(TIME_BASED_ACCESS_ENABLED))).findFirst();
            if (optionalProfileService.isEmpty()) {
                return now;
            }
            ProfileService timeBasedAccessProfileService = optionalProfileService.get();
            String allowedWeekDays = timeBasedAccessProfileService.getPropertyValue(TIME_BASED_ACCESS_WEEK_DAYS);
            if (allowedWeekDays == null) {
                return LocalDateTime.MIN;
            }
            int[] days = Arrays.stream(allowedWeekDays.split(",")).map(String::trim).mapToInt(Integer::parseInt).sorted().toArray();
            LocalTime startTime = TimeBasedAccessValidator.stringToTime(timeBasedAccessProfileService.getPropertyValue(TIME_BASED_ACCESS_START_TIME));
            LocalTime endTime = TimeBasedAccessValidator.stringToTime(timeBasedAccessProfileService.getPropertyValue(TIME_BASED_ACCESS_END_TIME)).withSecond(59).withNano(999999999);
            int todayWeekDay = now.getDayOfWeek().getValue();
            boolean isAccessAllowedToday = Arrays.binarySearch(days, todayWeekDay) >= 0;
            LocalDate todayDate = now.toLocalDate();
            if (isAccessAllowedToday) {
                LocalDateTime todayStartTime = LocalDateTime.of(todayDate, startTime);
                LocalDateTime todayEndTime = LocalDateTime.of(todayDate, endTime);
                if (now.isBefore(todayEndTime)) {
                    return todayStartTime.isBefore(now) ? now : todayStartTime;
                }
                if (allowedWeekDays.length() == 1) {
                    LocalDate nextDate = todayDate.plusDays(7L);
                    return LocalDateTime.of(nextDate, startTime);
                }
            }
            if ((nextAllowedWeekDay = Arrays.stream(days).filter(day -> day > todayWeekDay).findFirst()).isEmpty()) {
                nextAllowedWeekDay = OptionalInt.of(days[0]);
            }
            int daysToAdd = (nextAllowedWeekDay.getAsInt() - todayWeekDay + 7) % 7;
            LocalDate nextDate = todayDate.plusDays(daysToAdd);
            return LocalDateTime.of(nextDate, startTime);
        }
        return LocalDateTime.MIN;
    }

    public static LocalDateTime getNextSessionEndTime(Profile profile, LocalDateTime now) {
        if (profile != null) {
            boolean wholeWeekAccess;
            LocalTime endTime;
            Optional<ProfileService> optionalProfileService = profile.getServices().stream().filter(ps -> "true".equalsIgnoreCase(ps.getPropertyValue(TIME_BASED_ACCESS_ENABLED))).findFirst();
            if (optionalProfileService.isEmpty()) {
                return LocalDateTime.MAX;
            }
            ProfileService profileService = optionalProfileService.get();
            String allowedWeekDays = profileService.getPropertyValue(TIME_BASED_ACCESS_WEEK_DAYS);
            if (allowedWeekDays == null) {
                return LocalDateTime.MIN;
            }
            int[] days = Arrays.stream(allowedWeekDays.split(",")).map(String::trim).mapToInt(Integer::parseInt).sorted().toArray();
            LocalTime startTime = TimeBasedAccessValidator.stringToTime(profileService.getPropertyValue(TIME_BASED_ACCESS_START_TIME));
            boolean wholeDayAccess = Duration.between(startTime, endTime = TimeBasedAccessValidator.stringToTime(profileService.getPropertyValue(TIME_BASED_ACCESS_END_TIME)).withSecond(59).withNano(999999999)).toMinutes() == 1439L;
            boolean bl = wholeWeekAccess = days.length == 7 && IntStream.of(days).sum() == 28;
            if (wholeDayAccess && wholeWeekAccess) {
                return LocalDateTime.MAX;
            }
            if (wholeDayAccess) {
                return TimeBasedAccessValidator.getLastContiguousDay(days, now.toLocalDate());
            }
            if (TimeBasedAccessValidator.isAllowedTimeScope(profileService, now)) {
                return LocalDateTime.of(now.toLocalDate(), endTime);
            }
        }
        return LocalDateTime.MIN;
    }

    public static boolean isAllowedTimePeriod(Profile profile) {
        return TimeBasedAccessValidator.isAllowedTimePeriod(profile, LocalDateTime.now());
    }

    public static boolean isAllowedTimePeriod(Profile profile, LocalDateTime now) {
        if (profile == null) {
            return false;
        }
        return profile.getServices().stream().filter(profileService -> "true".equalsIgnoreCase(profileService.getPropertyValue(TIME_BASED_ACCESS_ENABLED))).findFirst().map(p -> TimeBasedAccessValidator.isAllowedWeekdayAndTimeScope(p, now)).orElse(true);
    }

    private static LocalDateTime getLastContiguousDay(int[] days, LocalDate now) {
        int dayOfWeek = now.getDayOfWeek().getValue();
        int startIndex = TimeBasedAccessValidator.indexInArray(days, dayOfWeek);
        if (startIndex != -1) {
            for (int deltaIndex = 0; deltaIndex < 7; ++deltaIndex) {
                int arrayIndex = (startIndex + deltaIndex) % days.length;
                int day = (dayOfWeek + deltaIndex - 1) % 7 + 1;
                if (deltaIndex != days.length && days[arrayIndex] == day) continue;
                long daysToAdd = (long)deltaIndex - 1L;
                return LocalDateTime.of(now.plusDays(daysToAdd), LocalTime.MAX);
            }
        }
        return LocalDateTime.MIN;
    }

    private static int indexInArray(int[] array, int value) {
        for (int index = 0; index < array.length; ++index) {
            if (value != array[index]) continue;
            return index;
        }
        return -1;
    }

    private static boolean isAllowedWeekdayAndTimeScope(ProfileService profileService, LocalDateTime now) {
        return TimeBasedAccessValidator.isAllowedWeekday(profileService) && TimeBasedAccessValidator.isAllowedTimeScope(profileService, now);
    }

    private static boolean isAllowedWeekday(ProfileService profileService) {
        int dayOfWeek = LocalDate.now().getDayOfWeek().getValue();
        String allowedWeekDays = profileService.getPropertyValue(TIME_BASED_ACCESS_WEEK_DAYS);
        if (allowedWeekDays == null) {
            return false;
        }
        try {
            List allowedWeekDaysList = Arrays.stream(allowedWeekDays.split(",")).map(Integer::parseInt).collect(Collectors.toList());
            return allowedWeekDaysList.contains(dayOfWeek);
        }
        catch (NumberFormatException e) {
            logger.debug("Failed to parse property [{}] with value [{}]", (Object)TIME_BASED_ACCESS_WEEK_DAYS, (Object)allowedWeekDays);
            return false;
        }
    }

    private static boolean isAllowedTimeScope(ProfileService profileService, LocalDateTime now) {
        try {
            LocalTime allowedStartTime = TimeBasedAccessValidator.stringToTime(profileService.getPropertyValue(TIME_BASED_ACCESS_START_TIME));
            LocalTime allowedEndTime = TimeBasedAccessValidator.stringToTime(profileService.getPropertyValue(TIME_BASED_ACCESS_END_TIME)).withSecond(59).withNano(999999999);
            return now.toLocalTime().isAfter(allowedStartTime) && now.toLocalTime().isBefore(allowedEndTime);
        }
        catch (DateTimeException e) {
            logger.debug("Failed to parse time based access time properties. {}", (Object)e.getMessage());
            return false;
        }
    }

    private static LocalTime stringToTime(String timeString) {
        if (timeString != null) {
            return LocalTime.parse(timeString, DateTimeFormatter.ofPattern("H:mm"));
        }
        throw new DateTimeException("Invalid format. Expected format H:mm.");
    }
}

