/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.session;

import com.ericsson.em.emc.logging.ExternalLogManager;
import com.ericsson.em.emc.logging.LogRecord;
import com.ericsson.em.emc.session.SessionLogRecord;
import com.ericsson.lwac.deployer.RequestContext;
import com.ericsson.lwac.security.session.SessionLogEvent;
import com.ericsson.lwac.security.session.SessionLogEventListener;
import com.ericsson.lwac.security.session.SessionManager;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Local;
import jakarta.ejb.Singleton;

@Singleton
@Local(value={SessionLogEventListener.class})
public class SessionListenerBean
implements SessionLogEventListener {
    @Resource
    private SessionManager sessionManager;
    @Resource
    private RequestContext requestContext;
    @EJB
    private ExternalLogManager externalLogManager;

    @Override
    public void onSessionLogEvent(SessionLogEvent event) {
        SessionLogRecord sessionLogRecord = new SessionLogRecord(event);
        sessionLogRecord.setRequestId(this.requestContext.get("x-request-id"));
        this.externalLogManager.publish((LogRecord)sessionLogRecord);
    }

    @PostConstruct
    public void postConstruct() {
        this.sessionManager.registerSessionLogEventListener(this);
    }
}

