/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.session;

import com.ericsson.em.emc.logging.ExternalLogManager;
import com.ericsson.em.emc.logging.LogHandler;
import com.ericsson.em.emc.logging.LogRecord;
import com.ericsson.em.emc.session.SessionLogRecord;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import jakarta.ejb.Local;
import jakarta.ejb.Singleton;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Local(value={LogHandler.class})
public class SessionLogConsoleHandler
implements LogHandler {
    private static final Logger logger = LoggerFactory.getLogger(SessionLogConsoleHandler.class);
    @EJB
    private ExternalLogManager externalLogManager;

    public boolean accept(LogRecord record) {
        return logger.isDebugEnabled() && record instanceof SessionLogRecord;
    }

    public void log(LogRecord record) {
        logger.debug("[SessionLog: {}] {}", (Object)record.getClass().getName(), (Object)record.toString());
    }

    public String format(SessionLogRecord record) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : record.getLogData().entrySet()) {
            builder.append(entry.getKey()).append("=").append(entry.getValue()).append(",");
        }
        if (builder.length() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    @PostConstruct
    public void postConstruct() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.externalLogManager.registerLogListener((LogHandler)this, this.getClass().getSimpleName());
    }
}

