/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.session;

import com.ericsson.em.emc.logging.LogRecord;
import com.ericsson.lwac.messagebus.ProducerProperties;
import com.ericsson.lwac.security.session.SessionLogEvent;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.DateTime;

public class SessionLogRecord
implements LogRecord,
Serializable {
    private static final long serialVersionUID = 8909383378930719858L;
    private final Map<String, String> logData = new TreeMap<String, String>();
    private final long sessionId;

    SessionLogRecord(SessionLogEvent sessionLogEvent) {
        if (sessionLogEvent.getSessionId() != 0L) {
            this.sessionId = sessionLogEvent.getSessionId();
            this.logData.put("sid", "" + this.sessionId);
        } else {
            this.sessionId = 0L;
        }
        if (sessionLogEvent.getUserIdentifier() != null) {
            this.logData.put("who", sessionLogEvent.getUserIdentifier());
        }
        if (sessionLogEvent.getAction() != null) {
            this.logData.put("action", sessionLogEvent.getAction().toString());
        }
        if (sessionLogEvent.getProtocol() != null) {
            this.logData.put("protocol", sessionLogEvent.getProtocol());
        }
        if (sessionLogEvent.getErrorDetails() != null) {
            this.logData.put("details", sessionLogEvent.getErrorDetails());
        }
        if (sessionLogEvent.getXForwardedForHeader() != null) {
            this.logData.put("clientAddressPath", sessionLogEvent.getXForwardedForHeader());
        }
        this.logData.put("time", new DateTime().toString());
    }

    public void setRequestId(String requestId) {
        if (requestId != null) {
            this.logData.put("requestId", requestId);
        }
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public Map<String, String> getLogData() {
        return this.logData;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.logData.entrySet()) {
            builder.append(entry.getKey()).append("=").append(entry.getValue()).append(",");
        }
        if (builder.length() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public ProducerProperties.AckPolicy getAckPolicy() {
        return ProducerProperties.AckPolicy.RECEIVED;
    }
}

