/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.tag.persistence;

import com.ericsson.lwac.ValidationException;
import com.ericsson.lwac.cache.Cacheable;
import com.ericsson.lwac.database.persistence.BaseEntity;

public class Tag
extends BaseEntity
implements Cacheable<Tag> {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private boolean statistics = false;
    private long version = 1L;

    public Tag() {
    }

    public Tag(Tag tag) {
        super((BaseEntity)tag);
        this.name = tag.name;
        this.description = tag.description;
        this.statistics = tag.statistics;
        this.version = tag.version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStatistics(boolean statsistics) {
        this.statistics = statsistics;
    }

    public boolean isStatistics() {
        return this.statistics;
    }

    protected void validate() {
        if (this.name == null) {
            throw new ValidationException("Name is missing.");
        }
        if (this.name.length() > 32) {
            throw new ValidationException("Name is too long.");
        }
        if (this.description != null && this.description.length() > 64) {
            throw new ValidationException("Description is too long.");
        }
    }

    protected void setVersion(long version) {
        this.version = version;
    }

    @Override
    public Tag deepClone() {
        return new Tag(this);
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void increaseVersion() {
        ++this.version;
    }
}

