/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.totp.persistence;

import com.ericsson.em.emc.totp.persistence.Totp;
import com.ericsson.em.emc.totp.persistence.TotpDAO;
import com.ericsson.lwac.crypto.EncryptedField;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

@Validatable
@Updatable
@Singleton
@CryptoKeys(keyAliases={"emcc.totp.S", "emcc.totp.secret.E"})
public class TotpDAOBean
extends CryptoExtendedBaseEntityDAOBean<Totp>
implements TotpDAO {
    public static final String TOTP_SECRET_KEY = "emcc.totp.secret.E";
    static final int TOTP_CURRENT_FINGERPRINT_VERSION = 1;
    static final String TOTP_FINGERPRINT_KEY = "emcc.totp.S";
    private static final String TABLE_NAME = "emcc$totp";
    private static final String SEQUENCE_NAME = "emcc$totp_seq";
    private static final String COLUMN_ID = "id";
    private static final String IDENTITY = "identity";
    private static final String CONFIGURATIONSTATUS = "configurationstatus";
    private static final String SECRET = "secret";
    private static final String SECRETKEYGENERATION = "secretkeygeneration";
    private static final String IV = "iv";
    private static final String FINGERPRINTKEYGENERATION = "fingerprintkeygeneration";
    private static final String FINGERPRINTVERSION = "fingerprintversion";
    private static final String FINGERPRINT = "fingerprint";
    private static final String VERSION = "version";
    private static final String[] COLUMNS = new String[]{"id", "identity", "secret", "configurationstatus", "iv", "secretkeygeneration", "fingerprint", "fingerprintversion", "fingerprintkeygeneration", "version"};

    @Override
    public Totp create(Totp otp) {
        return (Totp)super.create((BaseEntity)otp);
    }

    @Override
    public void delete(String identification) {
        this.delete("delete from emcc$totp where identity = ?", new Object[]{identification});
    }

    @Override
    public Totp find(long id) {
        return (Totp)super.find(id);
    }

    @Override
    public Totp find(String identity) {
        return (Totp)super.find(this.getSelectStatement() + " where lower(identity) = lower(?)", new Object[]{identity});
    }

    @Override
    public List<Totp> findAll() {
        return this.findMultiple(this.getSelectStatement(), new Object[0]);
    }

    public Totp update(Totp totp) {
        return (Totp)super.updateWithVersionCheck((BaseEntity)totp);
    }

    protected String getFingerprintKeyAlias() {
        return TOTP_FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 1;
    }

    protected String getEntitySimpleName() {
        return Totp.class.getSimpleName();
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    protected Totp createManagedEntity() {
        return new Totp();
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1) {
            return new Object[]{resultSet.getString(IDENTITY), resultSet.getBytes(SECRET), resultSet.getString(CONFIGURATIONSTATUS)};
        }
        return null;
    }

    public String getSequenceName() {
        return SEQUENCE_NAME;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public String[] getColumns() {
        return COLUMNS;
    }

    public boolean isVersionable() {
        return true;
    }

    public boolean isUpdatable() {
        return true;
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        Totp totp = (Totp)baseEntity;
        EncryptedField<String> secretEncryptedField = totp.getSecret();
        byte[] iv = null;
        byte[] secret = null;
        int secretLatestTransactionKeyGeneration = 0;
        if (secretEncryptedField != null) {
            iv = this.securityModuleTransaction.createIV(TOTP_FINGERPRINT_KEY, this.getUniqueSequenceNumber(this.getTableName()));
            secretLatestTransactionKeyGeneration = this.securityModuleTransaction.getLatestTransactionKeyGeneration(TOTP_SECRET_KEY);
            secret = this.securityModuleTransaction.encryptDAOString(TOTP_SECRET_KEY, secretLatestTransactionKeyGeneration, iv, (String)secretEncryptedField.getValue());
        }
        int i = 1;
        preparedStatement.setString(i++, totp.getIdentity());
        preparedStatement.setBytes(i++, secret);
        preparedStatement.setString(i++, totp.getConfigurationStatus());
        preparedStatement.setBytes(i++, iv);
        preparedStatement.setInt(i++, secretLatestTransactionKeyGeneration);
        i = this.assignFingerprint(preparedStatement, i, new Object[]{totp.getIdentity(), secret, totp.getConfigurationStatus()});
        return i;
    }

    public List<Totp> findEntriesToUpdateCrypto(int batchSize) {
        return this.findMultiple("select * from (" + this.getSelectStatement() + " where fingerprintkeygeneration < ? or secretkeygeneration < ? ) where rownum <= ?", new Object[]{this.securityModuleTransaction.getLatestTransactionKeyGeneration(TOTP_FINGERPRINT_KEY), this.securityModuleTransaction.getLatestTransactionKeyGeneration(TOTP_SECRET_KEY), batchSize});
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        Totp totp = (Totp)baseEntity;
        totp.setIdentity(resultSet.getString(IDENTITY));
        totp.setConfigurationStatus(resultSet.getString(CONFIGURATIONSTATUS));
        byte[] secret = resultSet.getBytes(SECRET);
        if (secret != null) {
            byte[] iv = resultSet.getBytes(IV);
            totp.setSecret((EncryptedField<String>)new EncryptedField(secret, iv, resultSet.getInt(SECRETKEYGENERATION), this.createDecryptionHandler()));
        }
        totp.setVersion(resultSet.getLong(VERSION));
    }

    private EncryptedField.DecryptionHandler<String> createDecryptionHandler() {
        return (encryptedArray, iv, keyGeneration) -> this.securityModuleTransaction.decryptDAOString(TOTP_SECRET_KEY, keyGeneration, iv, encryptedArray);
    }
}

