/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.transactionid;

import com.ericsson.em.emc.transactionid.TransactionIdService;
import com.ericsson.lwac.deployer.interceptor.Interceptor;
import com.ericsson.lwac.deployer.interceptor.InterceptorException;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TransactionIdInterceptor
implements Interceptor<Boolean> {
    private TransactionIdService transactionIdService;
    private static ThreadLocal<Boolean> started = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    @Override
    public Optional<Boolean> before(Method method, Object ... arguments) throws InterceptorException {
        boolean startedHere = false;
        if (!started.get().booleanValue()) {
            started.set(true);
            startedHere = true;
        }
        return Optional.of(startedHere);
    }

    @Override
    public void after(Boolean startedHere, Method method, Object ... arguments) throws InterceptorException {
        if (startedHere.booleanValue()) {
            started.set(false);
            this.getTransactionIdService().reset();
        }
    }

    @Override
    public void afterException(Boolean startedHere, Exception e, Method method, Object ... arguments) throws InterceptorException {
        this.after(startedHere, method, arguments);
    }

    private TransactionIdService getTransactionIdService() {
        try {
            if (this.transactionIdService == null) {
                InitialContext context = new InitialContext();
                this.transactionIdService = (TransactionIdService)context.lookup("java:/TransactionIdService");
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("TransactionIdService not found. Serious error", e);
        }
        return this.transactionIdService;
    }
}

