/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class Currency
implements Serializable,
Comparable<Currency> {
    private static final long serialVersionUID = 1L;
    private static final Map<String, Currency> currenciesByCode;
    private static final String LWAC_GUI_CURRENCY_PROPERTIES = "lwac.gui.currency.properties";
    private static final Pattern CUSTOM_CURRENCY_FORMAT;
    private final String currencyCode;
    private final transient int decimals;
    private final transient int numericCode;
    private final transient int originalScale;

    private static Map<String, Currency> getStandardCurrencies() {
        HashMap<String, Currency> standardCurrencies = new HashMap<String, Currency>();
        for (java.util.Currency curr : java.util.Currency.getAvailableCurrencies()) {
            String currencyCode = curr.getCurrencyCode();
            int noOfDecimals = curr.getDefaultFractionDigits() == -1 ? 0 : curr.getDefaultFractionDigits();
            int numericCode = curr.getNumericCode();
            standardCurrencies.put(currencyCode, new Currency(currencyCode, noOfDecimals, numericCode));
        }
        return standardCurrencies;
    }

    private static Map<String, Currency> getCustomCurrencies() {
        File file;
        Map<String, Currency> customCurrencies = new HashMap<String, Currency>();
        InputStream inputStream = null;
        String settings = System.getProperty(LWAC_GUI_CURRENCY_PROPERTIES);
        File file2 = file = settings != null ? new File(settings) : null;
        if (file != null && file.exists()) {
            try {
                inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("while loading currency.properties", e);
            }
        }
        if (inputStream == null) {
            inputStream = Currency.class.getResourceAsStream("/currency.properties");
        }
        if (inputStream != null) {
            customCurrencies = Currency.getCustomCurrenciesFromResource(inputStream);
        }
        return customCurrencies;
    }

    private static Map<String, Currency> getCustomCurrenciesFromResource(InputStream inputStream) {
        HashMap<String, Currency> customCurrencies = new HashMap<String, Currency>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            reader.lines().map(String::trim).filter(line -> !line.isEmpty()).filter(line -> !line.startsWith("#") && !line.startsWith("!")).forEach(line -> {
                Matcher matcher = CUSTOM_CURRENCY_FORMAT.matcher((CharSequence)line);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Invalid custom currency data specified: " + line);
                }
                String currencyCode = matcher.group(1);
                int numericCode = Integer.parseInt(matcher.group(2));
                int noOfDecimals = Integer.parseInt(matcher.group(3));
                customCurrencies.put(currencyCode, new Currency(currencyCode, noOfDecimals, numericCode));
            });
        }
        catch (IOException e) {
            throw new RuntimeException("while loading currency.properties", e);
        }
        return customCurrencies;
    }

    private static Map<String, Currency> setOriginalScaleForCustomCurrencies(Map<String, Currency> standardCurrencies, Map<String, Currency> customCurrencies) {
        return customCurrencies.values().stream().map(currency -> Currency.setOriginalScaleForCurrency(currency, standardCurrencies)).collect(Collectors.toMap(Currency::getCurrencyCode, currency -> currency));
    }

    private static Currency setOriginalScaleForCurrency(Currency currency, Map<String, Currency> standardCurrencies) {
        Integer originalScale = Optional.ofNullable(standardCurrencies.get(currency.getCurrencyCode())).map(Currency::getDefaultFractionDigits).orElse(currency.getDefaultFractionDigits());
        return new Currency(currency.getCurrencyCode(), currency.getDefaultFractionDigits(), currency.getNumericCode(), originalScale);
    }

    public static Currency getInstance(String currencyCode) {
        Currency c = currenciesByCode.get(currencyCode);
        if (c == null) {
            throw new IllegalArgumentException("Not supported currency code: " + currencyCode);
        }
        return c;
    }

    private Currency(String currencyCode, int noOfDecimals, int numericCode, int originalScale) {
        this.decimals = noOfDecimals;
        this.currencyCode = currencyCode;
        this.numericCode = numericCode;
        this.originalScale = originalScale;
    }

    private Currency(String currencyCode, int noOfDecimals, int numericCode) {
        this.decimals = noOfDecimals;
        this.currencyCode = currencyCode;
        this.numericCode = numericCode;
        this.originalScale = noOfDecimals;
    }

    public int getDefaultFractionDigits() {
        return this.decimals;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public int getNumericCode() {
        return this.numericCode;
    }

    public int getOriginalScale() {
        return this.originalScale;
    }

    public String toString() {
        return this.currencyCode;
    }

    public static Set<Currency> getAvailableCurrencies() {
        return new HashSet<Currency>(currenciesByCode.values());
    }

    private Object readResolve() {
        return currenciesByCode.get(this.currencyCode);
    }

    @Override
    public int compareTo(Currency o) {
        return this.currencyCode.compareTo(o.currencyCode);
    }

    public int hashCode() {
        return this.currencyCode.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Currency other = (Currency)obj;
        return this.currencyCode.equals(other.currencyCode);
    }

    static {
        CUSTOM_CURRENCY_FORMAT = Pattern.compile("^(?:.+)=\\s*([A-Z]{3})\\s*,\\s*(\\d{3,})\\s*,\\s*(\\d)\\s*$");
        Map<String, Currency> standardCurrencies = Currency.getStandardCurrencies();
        Map<String, Currency> customCurrencies = Currency.getCustomCurrencies();
        customCurrencies = Currency.setOriginalScaleForCustomCurrencies(standardCurrencies, customCurrencies);
        HashMap<String, Currency> resultCurrencies = new HashMap<String, Currency>();
        resultCurrencies.putAll(standardCurrencies);
        resultCurrencies.putAll(customCurrencies);
        currenciesByCode = Collections.unmodifiableMap(resultCurrencies);
    }
}

