/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.util;

import com.ericsson.em.emc.util.Amount;
import com.ericsson.em.emc.util.Currency;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Money
implements Comparable<Money>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final BigDecimal amount;
    private final Currency currency;

    Money(BigDecimal amount, Currency currency) {
        this(amount, RoundingMode.UNNECESSARY, currency);
    }

    Money(BigDecimal amount, RoundingMode roundingMode, Currency currency) {
        this.amount = amount.setScale(currency.getDefaultFractionDigits(), roundingMode);
        this.currency = currency;
        this.assertLessThanOracleMaximum(amount);
    }

    public Money(Money money) {
        this.amount = money.amount;
        this.currency = money.currency;
    }

    public static Money valueOf(String money, Currency currency) {
        BigDecimal amount = new BigDecimal(money);
        if (amount.scale() < 0 || amount.scale() > currency.getDefaultFractionDigits()) {
            throw new IllegalArgumentException("Money string must use scale " + currency.getDefaultFractionDigits());
        }
        return new Money(amount, currency);
    }

    public static Money valueOf(BigDecimal amount, Currency currency) {
        if (amount.scale() > currency.getDefaultFractionDigits()) {
            throw new IllegalArgumentException("Amount cannot be exactly represented as a Money: " + String.valueOf(amount) + ". Currency is: " + currency.toString());
        }
        return new Money(amount, currency);
    }

    public static Money zeroOf(Money other) {
        return new Money(BigDecimal.ZERO, other.getCurrency());
    }

    public static Money zeroOf(Currency currency) {
        return new Money(BigDecimal.ZERO, currency);
    }

    @Override
    public int compareTo(Money o) {
        this.assertCurrencyEqual(this, o);
        return this.amount.compareTo(o.amount);
    }

    public BigDecimal toBigDecimal() {
        return this.amount;
    }

    public Amount toAmount() {
        return Amount.valueOf(this);
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public Money add(Money debitAmount) {
        this.assertCurrencyEqual(this, debitAmount);
        return new Money(this.amount.add(debitAmount.amount), this.currency);
    }

    private void assertLessThanOracleMaximum(BigDecimal amount) {
        if (amount.precision() > 38) {
            throw new IllegalArgumentException("Amount cannot be greater than 38 digits");
        }
    }

    private void assertCurrencyEqual(Money money, Money amount) {
        if (money.currency != amount.currency) {
            throw new IllegalArgumentException(String.format("Currency mismatch: %s %s vs. %s %s", money.amount, money.currency.getCurrencyCode(), amount.amount, amount.currency.getCurrencyCode()));
        }
    }

    public Money subtract(Money creditAmount) {
        this.assertCurrencyEqual(this, creditAmount);
        return new Money(this.amount.subtract(creditAmount.amount), this.currency);
    }

    public Money negate() {
        return new Money(this.amount.negate(), this.currency);
    }

    public final boolean isZero() {
        return this.amount.compareTo(BigDecimal.ZERO) == 0;
    }

    public final boolean isNegative() {
        return this.amount.signum() == -1;
    }

    public final boolean isPositive() {
        return this.amount.signum() == 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.currency == null ? 0 : this.currency.getCurrencyCode().hashCode());
        result = 31 * result + (this.amount == null ? 0 : this.amount.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Money other = (Money)obj;
        if (this.currency == null ? other.currency != null : !this.currency.getCurrencyCode().equals(other.currency.getCurrencyCode())) {
            return false;
        }
        return !(this.amount == null ? other.amount != null : !this.amount.equals(other.amount));
    }

    public String toString() {
        return String.format("%s %s", this.amountToStringUsingDefaultScale(), this.currency.getCurrencyCode());
    }

    @Deprecated
    public String amountToString() {
        return this.amountToStringUsingDefaultScale();
    }

    public String amountToStringUsingIsoScale() {
        return this.amount.setScale(this.currency.getOriginalScale(), RoundingMode.HALF_UP).toPlainString();
    }

    public String amountToStringUsingDefaultScale() {
        return this.amount.toPlainString();
    }

    public String currencyToString() {
        return this.currency.getCurrencyCode();
    }

    public final boolean greaterThan(Money other) {
        this.assertCurrencyEqual(this, other);
        return this.compareTo(other) > 0;
    }

    public final boolean lessThan(Money other) {
        this.assertCurrencyEqual(this, other);
        return this.compareTo(other) < 0;
    }

    public Money inCurrency(Currency otherCurrency, BigDecimal fxRate, RoundingMode roundingMode) {
        BigDecimal otherAmount = this.amount.multiply(fxRate);
        BigDecimal currencyCorrectAmount = otherAmount.setScale(otherCurrency.getDefaultFractionDigits(), roundingMode);
        return new Money(currencyCorrectAmount, otherCurrency);
    }

    public Money min(Money other) {
        return this.lessThan(other) ? this : other;
    }
}

