/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.util;

import com.ericsson.em.emc.csv.MoneyAdaptor;
import com.ericsson.em.emc.util.Currency;
import com.ericsson.em.emc.util.Money;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MoneyHelper {
    private static final MoneyAdaptor moneyAdaptor = new MoneyAdaptor();
    private static final String DEFAULT_MONIES_SEPARATOR = ";";
    public static final BiFunction<Money, Currency, Money> NULLABLE_MONEY = (money, currency) -> Optional.ofNullable(money).orElse(Money.zeroOf(currency));

    public static String convertMoniesToString(List<Money> monies, String separator) {
        String moniesSeparator = separator == null ? DEFAULT_MONIES_SEPARATOR : separator;
        return monies.stream().map(moneyAdaptor::encode).collect(Collectors.joining(moniesSeparator));
    }

    public static String convertMoniesToString(List<Money> monies) {
        return MoneyHelper.convertMoniesToString(monies, DEFAULT_MONIES_SEPARATOR);
    }

    public static List<Money> convertStringToMonies(String data, String separator) {
        String moniesSeparator = separator == null ? DEFAULT_MONIES_SEPARATOR : separator;
        String[] dataArray = data.split(moniesSeparator);
        return Stream.of(dataArray).map(moneyAdaptor::decode).collect(Collectors.toList());
    }

    public static List<Money> convertStringToMonies(String data) {
        return MoneyHelper.convertStringToMonies(data, DEFAULT_MONIES_SEPARATOR);
    }

    public static Money valueFromResultSet(ResultSet resultSet, String amountLabel, String currencyLabel) throws SQLException {
        BigDecimal amount = resultSet.getBigDecimal(amountLabel);
        String currencyCode = resultSet.getString(currencyLabel);
        if (amount != null && currencyCode != null) {
            Currency currency = Currency.getInstance(currencyCode);
            return Money.valueOf(amount, currency);
        }
        return null;
    }

    public static Money valueFromResultSet(ResultSet resultSet, String amountLabel, String currencyLabel, String alternativeCurrencyLabel) throws SQLException {
        BigDecimal amount = resultSet.getBigDecimal(amountLabel);
        String currencyCode = resultSet.getString(currencyLabel);
        if (currencyCode == null) {
            currencyCode = resultSet.getString(alternativeCurrencyLabel);
        }
        if (amount != null && currencyCode != null) {
            Currency currency = Currency.getInstance(currencyCode);
            return Money.valueOf(amount, currency);
        }
        return null;
    }

    public static Money add(Money amount1, Money amount2) {
        if (amount1 == null) {
            return amount2;
        }
        if (amount2 == null) {
            return amount1;
        }
        return amount1.add(amount2);
    }

    public static Money valueFromResultSet(ResultSet resultSet, String amountLabel, Currency currency) throws SQLException {
        BigDecimal amount = resultSet.getBigDecimal(amountLabel);
        if (amount != null && currency != null) {
            return Money.valueOf(amount, currency);
        }
        return null;
    }

    public static int setNullableMoneyAmount(int i, Money money, PreparedStatement preparedStatement) throws SQLException {
        if (money != null) {
            preparedStatement.setBigDecimal(i++, money.toBigDecimal());
        } else {
            preparedStatement.setNull(i++, 2);
        }
        return i;
    }

    public static int setNullableMoneyCurrency(int i, Money money, PreparedStatement preparedStatement) throws SQLException {
        if (money != null) {
            preparedStatement.setString(i++, money.currencyToString());
        } else {
            preparedStatement.setNull(i++, 12);
        }
        return i;
    }

    public static final BigDecimal getNullableMoneyAsBigDecimal(ResultSet resultSet, String column, String currency) throws SQLException {
        Money money = MoneyHelper.valueFromResultSet(resultSet, column, currency);
        if (money == null) {
            return null;
        }
        return money.toBigDecimal();
    }

    public static final BigDecimal getNullableMoneyAsBigDecimal(ResultSet resultSet, String column, Currency currency) throws SQLException {
        Money money = MoneyHelper.valueFromResultSet(resultSet, column, currency);
        if (money == null) {
            return null;
        }
        return money.toBigDecimal();
    }

    public static final Currency getNullableCurrencyFromResultSet(ResultSet resultSet, String column) throws SQLException {
        String currencyCode = resultSet.getString(column);
        if (currencyCode != null) {
            return Currency.getInstance(currencyCode);
        }
        return null;
    }

    public static final int setNullableCurrency(int i, Currency currency, PreparedStatement preparedStatement) throws SQLException {
        if (currency != null) {
            preparedStatement.setString(i++, currency.getCurrencyCode());
        } else {
            preparedStatement.setNull(i++, 12);
        }
        return i;
    }
}

