/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.util;

import com.ericsson.em.emc.util.Currency;
import com.ericsson.em.emc.util.Money;
import com.ericsson.em.validation.Validation;
import com.ericsson.em.validators.IsPercentage;
import jakarta.validation.ValidationException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;

public final class MoneyPercentage
implements Serializable,
Comparable<MoneyPercentage> {
    private static final long serialVersionUID = 1L;
    @IsPercentage(allowNull=false, maxValue=100)
    private final BigDecimal value;
    private final BigDecimal fraction;

    private MoneyPercentage(BigDecimal value) {
        this.value = value;
        this.fraction = value.movePointLeft(2);
    }

    public static MoneyPercentage fromBigDecimal(BigDecimal value) {
        if (value == null) {
            return null;
        }
        try {
            return Validation.validate(new MoneyPercentage(value));
        }
        catch (NumberFormatException e) {
            throw new ValidationException(e);
        }
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public MoneySplit split(Money amount) {
        Objects.requireNonNull(amount);
        Currency currency = amount.getCurrency();
        BigDecimal amountBigDecimal = amount.toBigDecimal();
        Money quotient = Money.valueOf(amountBigDecimal.multiply(this.fraction).setScale(currency.getDefaultFractionDigits(), RoundingMode.HALF_UP), currency);
        Money remainder = amount.subtract(quotient);
        return new MoneySplit(quotient, remainder);
    }

    @Override
    public int compareTo(MoneyPercentage that) {
        return this.value.compareTo(that.value);
    }

    public String toString() {
        return this.value.toPlainString() + "%";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneyPercentage other = (MoneyPercentage)obj;
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }

    public static class MoneySplit
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Money mainPart;
        private final Money remainder;

        MoneySplit(Money quotient, Money remainder) {
            this.mainPart = quotient;
            this.remainder = remainder;
        }

        public Money getMainPart() {
            return this.mainPart;
        }

        public Money getRemainder() {
            return this.remainder;
        }
    }
}

