/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.rma.connector;

import com.ericsson.ere.swing.EDT;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.AbstractDialog;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.Callable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public final class KeyStorePasswordDialog
extends AbstractDialog {
    private JButton myCancelButton;
    private JButton myOKButton;
    private JPanel myButtonPanel;
    private JPanel myMainPanel;
    private JPasswordField myPasswordField;
    private boolean myIsAccepted = false;
    private String myPassword;

    private KeyStorePasswordDialog() {
        super((Frame)GuiServiceCenter.getInstance().getMainWindow(), true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.myOKButton);
        this.myPasswordField.setText("");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                JPasswordField focusedComponent = KeyStorePasswordDialog.this.myPasswordField;
                if (!KeyStorePasswordDialog.this.requestFocusInWindow()) {
                    KeyStorePasswordDialog.this.requestFocus();
                }
                ((Component)focusedComponent).requestFocusInWindow();
            }
        });
        this.center();
    }

    private void initComponents() {
        JLabel passwordLabel = new JLabel();
        this.myMainPanel = new JPanel();
        this.myPasswordField = new JPasswordField();
        this.myButtonPanel = new JPanel();
        this.myOKButton = new JButton();
        this.myCancelButton = new JButton();
        this.setName("PasswordDialog");
        this.myPasswordField.setName("LoginDialog.Password");
        this.myOKButton.setName("LoginDialog.OkButton");
        this.myCancelButton.setName("LoginDialog.CancelButton");
        this.setTitle("KeyStore");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                KeyStorePasswordDialog.this.closeDialog();
            }
        });
        this.myMainPanel.setLayout(new GridBagLayout());
        this.myMainPanel.setBorder(new TitledBorder(new EtchedBorder(), "Enter KeyStore Password"));
        passwordLabel.setFont(new Font("Dialog", 0, 12));
        passwordLabel.setText("Password:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.myMainPanel.add((Component)passwordLabel, gridBagConstraints);
        this.myPasswordField.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        this.myMainPanel.add((Component)this.myPasswordField, gridBagConstraints);
        this.myOKButton.setText("OK");
        this.myOKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyStorePasswordDialog.this.btnOKActionPerformed();
            }
        });
        this.myButtonPanel.add(this.myOKButton);
        this.myCancelButton.setText("Cancel");
        this.myCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyStorePasswordDialog.this.performCancel();
            }
        });
        this.myButtonPanel.add(this.myCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        this.myMainPanel.add((Component)this.myButtonPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.myMainPanel, "Center");
        this.pack();
    }

    private void btnOKActionPerformed() {
        this.myPassword = new String(this.myPasswordField.getPassword());
        this.myIsAccepted = true;
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isAccepted() {
        return this.myIsAccepted;
    }

    private static KeyStorePasswordDialog createInstance() {
        return new KeyStorePasswordDialog();
    }

    public static String getPassword() throws Exception {
        return EDT.runAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                KeyStorePasswordDialog dialog = KeyStorePasswordDialog.createInstance();
                dialog.setVisible(true);
                if (dialog.isAccepted()) {
                    return dialog.myPassword;
                }
                return null;
            }
        });
    }
}

