/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.rma.custom.view;

import com.ericsson.em.emm.ere.rma.custom.model.CollectionOfMultiFieldsModel;
import com.ericsson.em.emm.ere.rma.custom.view.AbstractCollectionOfMultiFieldEntryVariable;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.PanelVariableEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class CollectionOfMultiFieldEntryNameVariable
extends AbstractCollectionOfMultiFieldEntryVariable
implements Observer {
    private String entryName = "";

    public CollectionOfMultiFieldEntryNameVariable(String label, CollectionOfMultiFieldsModel model) {
        super(label, model);
        this.model.addObserver(this);
    }

    @Override
    public Object getValueObject() {
        return this.model;
    }

    @Override
    public CollectionOfMultiFieldsModel getModel() {
        return this.model;
    }

    @Override
    protected PanelVariableEditor createPanelVariableEditor() {
        return new CollectionOfMultiFieldEntryNamePanel(this, this.model);
    }

    private void dataChanged(String entryName) {
        this.entryName = entryName;
        this.fireValueChanged();
    }

    @Override
    public void update(Observable o, Object arg) {
        assert (this.model == o);
        if (o instanceof CollectionOfMultiFieldsModel) {
            CollectionOfMultiFieldsModel.ModelStatus status;
            CollectionOfMultiFieldsModel currModel = (CollectionOfMultiFieldsModel)o;
            if (arg instanceof CollectionOfMultiFieldsModel.ModelStatus && ((status = (CollectionOfMultiFieldsModel.ModelStatus)((Object)arg)).equals((Object)CollectionOfMultiFieldsModel.ModelStatus.ENTRY_SELECTED) || status.equals((Object)CollectionOfMultiFieldsModel.ModelStatus.ENTRY_DELETED) || status.equals((Object)CollectionOfMultiFieldsModel.ModelStatus.NEW_ENTRY_ADDED))) {
                CollectionOfMultiFieldEntryNamePanel panel = (CollectionOfMultiFieldEntryNamePanel)this.getPanelVariableEditor();
                panel.updatePanel(currModel);
            }
        }
    }

    public String getEntryName() {
        return this.entryName;
    }

    private static class CollectionOfMultiFieldEntryNamePanel
    extends AbstractPanelVariableEditor
    implements PanelVariableEditor {
        private static final String BUTTON_ACTION_NAME = "Update";
        private static final String BUTTON_ACTION_SHORT_DESCRIPTION = "Update Entry Name";
        private final transient CollectionOfMultiFieldEntryNameVariable variable;
        private final TextFieldButtonPair fieldButtonPair;

        CollectionOfMultiFieldEntryNamePanel(CollectionOfMultiFieldEntryNameVariable variable, CollectionOfMultiFieldsModel model) {
            super(new BorderLayout());
            this.variable = variable;
            this.fieldButtonPair = this.setupPanel();
            this.updatePanel(model);
        }

        @Override
        public boolean isEditorValueValid() {
            return false;
        }

        @Override
        public Object getEditorValue() {
            return null;
        }

        private TextFieldButtonPair setupPanel() {
            TextFieldButtonPair fieldButtonPair = new TextFieldButtonPair();
            this.add(fieldButtonPair);
            return fieldButtonPair;
        }

        void updatePanel(CollectionOfMultiFieldsModel model) {
            String entryName = model.getCurrentEntryName();
            this.fieldButtonPair.textField.setText(entryName);
            this.fieldButtonPair.updateButton.setEnabled(!entryName.isEmpty());
        }

        private class TextFieldButtonPair
        extends JPanel
        implements DocumentListener {
            JTextComponent textField;
            JButton updateButton;

            TextFieldButtonPair() {
                super(new BorderLayout());
                this.textField = new JTextField();
                this.textField.setName("CollectionOfMultiFieldEntriesPanel.JTextField.EntryName");
                this.textField.getDocument().addDocumentListener(this);
                this.add((Component)this.textField, "Center");
                UpdateEntryNameAction updateAction = new UpdateEntryNameAction();
                this.updateButton = new JButton(updateAction){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension pref = super.getPreferredSize();
                        Font f = this.getFont();
                        FontMetrics fm = this.getFontMetrics(f);
                        int w = fm.stringWidth(CollectionOfMultiFieldEntryNamePanel.BUTTON_ACTION_NAME);
                        Insets ins = this.getInsets();
                        pref.width = ins.left + w + ins.right;
                        return pref;
                    }
                };
                this.updateButton.setName("CollectionOfMultiFieldEntriesPanel.JTextField.EntryName.Update");
                this.add((Component)this.updateButton, "East");
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateButtonState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateButtonState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateButtonState();
            }

            private void updateButtonState() {
                String text = this.textField.getText();
                this.updateButton.setEnabled(!text.isEmpty() && text.length() < 30);
            }
        }

        private class UpdateEntryNameAction
        extends AbstractAction {
            UpdateEntryNameAction() {
                this.putValue("ShortDescription", CollectionOfMultiFieldEntryNamePanel.BUTTON_ACTION_SHORT_DESCRIPTION);
                this.putValue("Name", CollectionOfMultiFieldEntryNamePanel.BUTTON_ACTION_NAME);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String newEntryName = CollectionOfMultiFieldEntryNamePanel.this.fieldButtonPair.textField.getText();
                if (!newEntryName.isEmpty()) {
                    CollectionOfMultiFieldEntryNamePanel.this.variable.dataChanged(newEntryName);
                }
            }
        }
    }
}

