/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.util;

import com.ericsson.em.emm.util.AbstractValueObject;
import com.ericsson.em.emm.util.MaskedValueObject;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class SensitiveValueObject
extends AbstractValueObject
implements MaskedValueObject {
    private static final String MASKING_CHARACTER = "*";
    private static final Pattern MASK_ALL = Pattern.compile(".");

    @Override
    public abstract String getValueAsString();

    @Override
    public final String toString() {
        return this.maskValue(this.getValueAsString());
    }

    private String maskValue(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        Pattern regexToMaskWith = this.getRegexToMaskWith();
        if (Objects.isNull(regexToMaskWith)) {
            return SensitiveValueObject.getWholeValueMasked(value);
        }
        Matcher matcher = regexToMaskWith.matcher(value);
        if (!matcher.find() || !SensitiveValueObject.hasGroup(matcher)) {
            return SensitiveValueObject.getWholeValueMasked(value);
        }
        String maskedValue = value;
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            maskedValue = maskedValue.replaceAll(matcher.group(i), MASKING_CHARACTER.repeat(matcher.group(i).length()));
        }
        return maskedValue;
    }

    private static boolean hasGroup(Matcher regexToMaskWith) {
        return regexToMaskWith.groupCount() > 0;
    }

    private static String getWholeValueMasked(String value) {
        return MASK_ALL.matcher(value).replaceAll(MASKING_CHARACTER);
    }
}

