/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.web.ere.rma;

import com.ericsson.em.emm.web.ere.rma.ReactiveKeyStore;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.function.Supplier;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty {
    private static final Logger LOGGER = LoggerFactory.getLogger("Jetty");

    public static void main(String[] args) {
        int port = Integer.parseInt(System.getenv("PORT"));
        Server server = new Server(InetSocketAddress.createUnresolved("0.0.0.0", port));
        WebAppContext web = new WebAppContext();
        web.setContextPath("/");
        web.setWar(System.getenv("JETTY_HOME") + "/root.war");
        boolean isTls = ReactiveKeyStore.hasCertificates();
        if (isTls) {
            LOGGER.info("Starting server");
            web.setDescriptor(System.getenv("JETTY_HOME") + "/web-ssl.xml");
            server.setHandler((Supplier)web);
            Jetty.startTls(server, port);
        } else {
            LOGGER.warn("!! Starting server without TLS !!");
            try {
                web.setDescriptor(System.getenv("JETTY_HOME") + "/web.xml");
                server.setHandler((Supplier)web);
                server.start();
                server.join();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void startTls(Server server, int port) {
        try (ServerConnector connector = Jetty.createServerConnector(server, port);){
            server.setConnectors(new Connector[]{connector});
            server.start();
            server.join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ServerConnector createServerConnector(Server server, int port) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        HttpConfiguration https = new HttpConfiguration();
        SecureRequestCustomizer customizer = new SecureRequestCustomizer();
        customizer.setSniHostCheck(false);
        https.addCustomizer((HttpConfiguration.Customizer)customizer);
        ReactiveKeyStore mutualAuthorizationKeyStore = new ReactiveKeyStore(new SslContextFactory.Server());
        mutualAuthorizationKeyStore.start();
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(mutualAuthorizationKeyStore.getSslContextFactory(), "http/1.1"), new HttpConnectionFactory(https)});
        connector.setHost("0.0.0.0");
        connector.setPort(port);
        return connector;
    }
}

