/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.web.ere.rma;

import com.ericsson.em.emm.web.ere.rma.FileWatcher;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveKeyStore {
    private static final Logger LOGGER = LoggerFactory.getLogger("ReactiveKeyStore");
    private static Path basePath = Optional.ofNullable(System.getenv("TLS_DIR")).map(x$0 -> Paths.get(x$0, new String[0])).orElse(Paths.get("/var/lib/jetty/tls/http/certs", new String[0]));
    private static Path keyStorePath = Optional.ofNullable(System.getenv("KEYSTORE_DIR")).map(x$0 -> Paths.get(x$0, new String[0])).orElse(Paths.get("/var/lib/jetty/etc", new String[0]));
    private final Path rmaCertificatePath = basePath.resolve("srvcert.pem");
    private final Path rmaKeyPath = basePath.resolve("srvprivkey.pem");
    private final KeyStore keyStore;
    private final String generatedToken;
    private final CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
    private final KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA");
    private final KeyFactory ecKeyFactory = KeyFactory.getInstance("EC");
    private final List<Runnable> keyStoreChangeListeners = new ArrayList<Runnable>();
    private final SslContextFactory.Server sslContextFactory;

    public static boolean hasCertificates() {
        return Files.exists(basePath.resolve("srvcert.pem"), new LinkOption[0]);
    }

    public void registerKeyStoreChangeListener(Runnable onChange) {
        this.keyStoreChangeListeners.add(onChange);
    }

    public ReactiveKeyStore(SslContextFactory.Server sslContextFactory) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        this.sslContextFactory = sslContextFactory;
        this.keyStore = KeyStore.getInstance("PKCS12");
        this.generatedToken = UUID.randomUUID().toString();
        this.keyStore.load(null);
        try (OutputStream outputStream = Files.newOutputStream(keyStorePath.resolve("KeyStore"), new OpenOption[0]);){
            this.keyStore.store(outputStream, this.generatedToken.toCharArray());
        }
        this.keyStore.setKeyEntry("rma", this.createPrivateKey(this.rmaKeyPath), this.generatedToken.toCharArray(), this.getCertificateChain(this.rmaCertificatePath));
        this.updateSslContextFactory();
        this.registerKeyStoreChangeListener(() -> {
            try {
                sslContextFactory.reload(context -> LOGGER.info("Reloading SSL context with keystore changes"));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to reload SSL context with keystore changes", (Object)e.getMessage());
            }
        });
    }

    public void start() throws IOException {
        new Thread(new FileWatcher(basePath, this::loadNewCertificatesInKeyStore)).start();
    }

    public final void updateSslContextFactory() {
        this.sslContextFactory.setKeyStore(this.keyStore);
        this.sslContextFactory.setKeyStorePassword(this.generatedToken);
    }

    public SslContextFactory.Server getSslContextFactory() {
        return this.sslContextFactory;
    }

    private void loadNewCertificatesInKeyStore() {
        try {
            this.keyStore.setKeyEntry("rma", this.createPrivateKey(this.rmaKeyPath), this.generatedToken.toCharArray(), this.getCertificateChain(this.rmaCertificatePath));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to update certificate", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        this.keyStoreChangeListeners.forEach(Runnable::run);
        LOGGER.info("Updated certificates");
    }

    private Certificate[] getCertificateChain(Path certificatePath) throws IOException, CertificateException {
        return this.getCertificatesFromFile(certificatePath);
    }

    private Certificate[] getCertificatesFromFile(Path file) throws IOException, CertificateException {
        ArrayList<Certificate> result = new ArrayList<Certificate>();
        try (BufferedReader reader = Files.newBufferedReader(file);){
            String nextLine = reader.readLine();
            if (nextLine == null || !nextLine.contains("BEGIN CERTIFICATE")) {
                throw new IllegalArgumentException("no CERTIFICATE found");
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (nextLine != null) {
                if (nextLine.contains("END CERTIFICATE")) {
                    String hexString = stringBuilder.toString();
                    byte[] bytes = Base64.getDecoder().decode(hexString);
                    Certificate cert = this.generateCertificate(bytes);
                    result.add(cert);
                    stringBuilder = new StringBuilder();
                } else if (!nextLine.startsWith("----")) {
                    stringBuilder.append(nextLine);
                }
                nextLine = reader.readLine();
            }
        }
        return result.toArray(new Certificate[0]);
    }

    private PrivateKey createPrivateKey(Path file) throws IOException, InvalidKeySpecException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader reader = Files.newBufferedReader(file);){
            String nextLine = reader.readLine();
            if (nextLine == null || !nextLine.contains("BEGIN PRIVATE KEY")) {
                throw new IllegalArgumentException("no PRIVATE KEY found");
            }
            nextLine = "";
            while (nextLine != null) {
                if (nextLine.contains("END PRIVATE KEY")) {
                    break;
                }
                stringBuilder.append(nextLine);
                nextLine = reader.readLine();
            }
        }
        String hexString = stringBuilder.toString();
        byte[] bytes = Base64.getDecoder().decode(hexString);
        return this.generatePrivateKey(bytes);
    }

    private Certificate generateCertificate(byte[] certBytes) throws CertificateException {
        return this.certificateFactory.generateCertificate(new ByteArrayInputStream(certBytes));
    }

    private PrivateKey generatePrivateKey(byte[] keyBytes) throws InvalidKeySpecException {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        return this.generateRsaOrEcKey(spec);
    }

    private PrivateKey generateRsaOrEcKey(PKCS8EncodedKeySpec spec) throws InvalidKeySpecException {
        PrivateKey privateKey;
        try {
            privateKey = this.ecKeyFactory.generatePrivate(spec);
        }
        catch (InvalidKeySpecException e) {
            LOGGER.debug("Key is not EC, generating RSA");
            privateKey = this.rsaKeyFactory.generatePrivate(spec);
        }
        return privateKey;
    }

    static void setBasePath(Path basePath) {
        ReactiveKeyStore.basePath = basePath;
    }

    static void setKeyStorePath(Path keyStorePath) {
        ReactiveKeyStore.keyStorePath = keyStorePath;
    }
}

