/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.web.ere.rma;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

public class RmaExceptionHandler
extends HttpServlet {
    private Throwable throwable;
    private Integer statusCode;
    private String servletName;
    private String requestUri;
    private String title;

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.throwable = (Throwable)request.getAttribute("javax.servlet.error.exception");
        this.statusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        this.servletName = (String)request.getAttribute("javax.servlet.error.servlet_name");
        if (this.servletName == null) {
            this.servletName = "Unknown";
        }
        this.requestUri = (String)request.getAttribute("javax.servlet.error.request_uri");
        if (this.requestUri == null) {
            this.requestUri = "Unknown";
        }
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        this.title = "Exception Information";
        String docType = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">";
        out.println(docType + "<html>\n<head><title>" + this.title + "</title></head>\n<body>\n");
        if (this.throwable == null && this.statusCode == null) {
            out.println("<h1>Error information not found</h1>");
        } else if (this.statusCode != null) {
            out.println("HTTP status code: " + this.statusCode);
        } else {
            out.println("<h2>Error information</h2>");
            out.println("Servlet Name : " + this.servletName + "</br></br>");
            out.println("Exception Type : " + this.throwable.getClass().getName() + "</br></br>");
            out.println("The request URI: " + this.requestUri + "<br><br>");
            out.println("The exception message: " + this.throwable.getMessage());
        }
        out.println("</body>");
        out.println("</html>");
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

