/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.accountholderconsent.v1_0.common;

import com.ericsson.em.m3if.accountholderconsent.v1_0.common.PostalCode;
import com.ericsson.em.m3if.accountholderconsent.v1_0.common.StreetAddress;
import com.ericsson.em.m3if.v1_0.common.MessageValue;
import com.ericsson.em.m3if.v1_0.common.NameValue;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/accountholderconsent/v1_0/common", name="address")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/accountholderconsent/v1_0/common", name="", propOrder={"streetAddress", "postalCode", "city", "province", "country", "formattedAddress"})
public class Address
implements Serializable {
    private static final long serialVersionUID = 4926388611666747892L;
    private static final Pattern ANY_WHITESPACE_FOLLOWED_BY_NEWLINE_AND_ANY_WHITESPACE = Pattern.compile("\\s*\\n\\s*");
    @Valid
    @XmlElement(name="streetaddress")
    private StreetAddress streetAddress;
    @Valid
    @XmlElement(name="postalcode")
    private PostalCode postalCode;
    @Valid
    @XmlElement(name="locality")
    private NameValue city;
    @Valid
    @XmlElement(name="region")
    private NameValue province;
    @Valid
    @XmlElement(name="country")
    private NameValue country;
    @Valid
    @XmlElement(name="formattedaddress")
    private MessageValue formattedAddress = MessageValue.fromString("");

    public StreetAddress getStreetAddress() {
        return this.streetAddress;
    }

    public void setStreetAddress(StreetAddress streetAddress) {
        this.streetAddress = streetAddress;
        this.formattedAddress = this.generateFormattedAddress();
    }

    public PostalCode getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(PostalCode postalCode) {
        this.postalCode = postalCode;
        this.formattedAddress = this.generateFormattedAddress();
    }

    public NameValue getCity() {
        return this.city;
    }

    public void setCity(NameValue city) {
        this.city = city;
        this.formattedAddress = this.generateFormattedAddress();
    }

    public NameValue getProvince() {
        return this.province;
    }

    public void setProvince(NameValue province) {
        this.province = province;
        this.formattedAddress = this.generateFormattedAddress();
    }

    public NameValue getCountry() {
        return this.country;
    }

    public void setCountry(NameValue country) {
        this.country = country;
        this.formattedAddress = this.generateFormattedAddress();
    }

    public MessageValue getFormattedAddress() {
        return this.formattedAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.streetAddress, address.streetAddress) && Objects.equals(this.postalCode, address.postalCode) && Objects.equals(this.city, address.city) && Objects.equals(this.province, address.province) && Objects.equals(this.country, address.country) && Objects.equals(this.formattedAddress, address.formattedAddress);
    }

    public int hashCode() {
        return Objects.hash(this.streetAddress, this.postalCode, this.city, this.province, this.country, this.formattedAddress);
    }

    private MessageValue generateFormattedAddress() {
        String untrimmedAddress = String.format("%s\n%s %s\n%s\n%s", this.streetAddress == null ? "" : this.streetAddress, this.postalCode == null ? "" : this.postalCode, this.city == null ? "" : this.city, this.province == null ? "" : this.province, this.country == null ? "" : this.country);
        return MessageValue.fromString(ANY_WHITESPACE_FOLLOWED_BY_NEWLINE_AND_ANY_WHITESPACE.matcher(untrimmedAddress.trim()).replaceAll("\n"));
    }
}

