/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.accountholderconsent.v1_0.common;

import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.validators.IsPositiveLong;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/accountholderconsent/v1_0/common", name="updatedat")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/accountholderconsent/v1_0/common", name="", propOrder={"dateTime", "epochSeconds"})
public class UpdatedAt
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    @XmlElement(name="datetime")
    private final Iso8601DateTime dateTime;
    @IsPositiveLong
    @XmlElement(name="epochseconds")
    private final Long epochSeconds;

    protected UpdatedAt() {
        this.dateTime = null;
        this.epochSeconds = null;
    }

    private UpdatedAt(Iso8601DateTime dateTime) {
        this.dateTime = dateTime;
        this.epochSeconds = dateTime != null ? Long.valueOf(dateTime.getValueAsZonedDateTime().toEpochSecond()) : null;
    }

    public static UpdatedAt fromLocalDatetime(LocalDateTime lastUpdated) {
        if (lastUpdated == null) {
            return null;
        }
        return new UpdatedAt(Iso8601DateTime.fromLocalDateTime(lastUpdated));
    }

    public Iso8601DateTime getDateTime() {
        return this.dateTime;
    }

    public Long getEpochSeconds() {
        return this.epochSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdatedAt updatedAt = (UpdatedAt)o;
        return Objects.equals(this.dateTime, updatedAt.dateTime) && Objects.equals(this.epochSeconds, updatedAt.epochSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.dateTime, this.epochSeconds);
    }
}

