/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.admin.common;

import com.ericsson.lwac.remote.jmx.Private;
import java.util.Arrays;
import java.util.Optional;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@Private
@XmlType(namespace="http://www.ericsson.com/em/emm/admin/common", name="weekday")
@XmlEnum
public enum WeekDay {
    MONDAY(1),
    TUESDAY(2),
    WEDNESDAY(3),
    THURSDAY(4),
    FRIDAY(5),
    SATURDAY(6),
    SUNDAY(7);

    @XmlTransient
    private final int dayNumber;

    private WeekDay(int dayNumber) {
        this.dayNumber = dayNumber;
    }

    public int getDayNumber() {
        return this.dayNumber;
    }

    public static WeekDay fromNumber(int dayNumber) {
        Optional<WeekDay> matchingWeekDay = Arrays.stream(WeekDay.values()).filter(it -> it.getDayNumber() == dayNumber).findFirst();
        if (matchingWeekDay.isPresent()) {
            return matchingWeekDay.get();
        }
        throw new IllegalArgumentException("Invalid week day number");
    }
}

