/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.batchtransaction.v1_0.uploadbatch;

import com.ericsson.em.m3if.operations.validation.IsDateTimeValue;
import com.ericsson.em.m3if.v1_0.common.DateTimeValue;
import com.ericsson.em.m3if.v1_0.common.PurposeCodeValue;
import com.ericsson.em.m3if.v1_0.common.ValidityDays;
import jakarta.validation.Valid;
import java.io.InputStream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/batchtransaction/v1_0", name="uploadbatchrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/batchtransaction/v1_0", name="", propOrder={"purposeCode", "scheduledDate", "validityDays"})
public class UploadBatchRequest {
    @Valid
    @XmlElement(name="purposecode")
    PurposeCodeValue purposeCode;
    @Valid
    @IsDateTimeValue
    @XmlElement(name="scheduleddate")
    private DateTimeValue scheduledDate;
    @Valid
    @XmlElement(name="validitydays", type=ValidityDays.class)
    private ValidityDays validityDays;
    @XmlTransient
    private InputStream inputStream;

    public UploadBatchRequest() {
    }

    public ValidityDays getValidityDays() {
        return this.validityDays;
    }

    public void setValidityDays(ValidityDays validityDays) {
        this.validityDays = validityDays;
    }

    public UploadBatchRequest(InputStream inputStream) {
        this.setInputStream(inputStream);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public DateTime getScheduledDate() {
        return this.scheduledDate != null ? this.scheduledDate.getTimestampAsDate() : null;
    }

    public PurposeCodeValue getPurposeCode() {
        return this.purposeCode;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setScheduledDate(DateTime scheduledDate) {
        this.scheduledDate = scheduledDate != null ? new DateTimeValue(scheduledDate) : null;
    }

    public void setPurposeCode(PurposeCodeValue purposeCode) {
        this.purposeCode = purposeCode;
    }
}

