/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.batchtransfer.v1_0.common;

import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsMultilineRestrictedString;
import com.ericsson.em.validators.IsNumericString;
import com.ericsson.em.validators.IsSingleWordString;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/batchtransfer/v1_0/common", name="batchreversaltransactionrecordtype", propOrder={"reversedTransactionId", "reversedTransactionDateTime", "amount", "result", "reason", "reversalFee", "reversedAmount"})
public class BatchReversalTransactionRecord
implements Serializable {
    private static final long serialVersionUID = 5791154676363273998L;
    @IsNumericString
    @XmlElement(name="reversedtransactionid")
    private String reversedTransactionId;
    @XmlElement(name="reversedtransactiondatetime")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date reversedTransactionDateTime;
    @Valid
    @XmlElement(name="amount")
    @IsPositiveAmount
    private MoneyDetails amount;
    @IsSingleWordString
    @XmlElement(name="result")
    private String result;
    @IsMultilineRestrictedString
    @XmlElement(name="reason")
    private String reason;
    @Valid
    @XmlElement(name="reversalfee")
    @IsPositiveAmount
    private MoneyDetails reversalFee;
    @Valid
    @XmlElement(name="reversedamount")
    @IsPositiveAmount
    private MoneyDetails reversedAmount;

    public String getReversedTransactionId() {
        return this.reversedTransactionId;
    }

    public void setReversedTransactionId(String reversedTransactionId) {
        this.reversedTransactionId = reversedTransactionId;
    }

    public DateTime getReversedTransactionDateTime() {
        return this.reversedTransactionDateTime == null ? null : new DateTime(this.reversedTransactionDateTime);
    }

    public void setReversedTransactionDateTime(DateTime reversedTransactionDateTime) {
        this.reversedTransactionDateTime = reversedTransactionDateTime == null ? null : reversedTransactionDateTime.toDate();
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public MoneyDetails getReversalFee() {
        return this.reversalFee;
    }

    public void setReversalFee(MoneyDetails reversalFee) {
        this.reversalFee = reversalFee;
    }

    public MoneyDetails getReversedAmount() {
        return this.reversedAmount;
    }

    public void setReversedAmount(MoneyDetails reversedAmount) {
        this.reversedAmount = reversedAmount;
    }
}

