/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.billmanager.v1_1.common;

import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.FirstnameValue;
import com.ericsson.em.m3if.v1_0.common.IdentityValue;
import com.ericsson.em.m3if.v1_0.common.Iso8601Date;
import com.ericsson.em.m3if.v1_0.common.MessageValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.SurnameValue;
import com.ericsson.em.validators.IsExternalReferenceString;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="billdetails", namespace="http://www.ericsson.com/em/emm/billmanager/v1_1/common", propOrder={"billProviderFRI", "billProviderDescriptiveName", "accountHolderIdentity", "firstName", "lastName", "customerReference", "billReference", "amount", "amountPaid", "message", "dueDate"})
public class BillDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    @NotNull
    @XmlElement(name="billproviderfri", required=true)
    private FRIValue billProviderFRI;
    @Length(max=48)
    @IsRestrictedString
    @XmlElement(name="billproviderdescriptivename")
    private String billProviderDescriptiveName;
    @Valid
    @XmlElement(name="accountholderidentity")
    private IdentityValue accountHolderIdentity;
    @Valid
    @XmlElement(name="firstname")
    private FirstnameValue firstName;
    @Valid
    @XmlElement(name="lastname")
    private SurnameValue lastName;
    @Valid
    @IsExternalReferenceString
    @Length(max=50)
    @XmlElement(name="customerreference")
    private String customerReference;
    @Valid
    @IsExternalReferenceString
    @Length(max=50)
    @XmlElement(name="billreference")
    private String billReference;
    @Valid
    @NotNull
    @IsPositiveAmount
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    private MoneyDetails amount;
    @Valid
    @NotNull
    @XmlElement(name="amountpaid", type=MoneyDetails.class, required=true)
    private MoneyDetails amountPaid;
    @Valid
    @XmlElement(name="message")
    private MessageValue message;
    @Valid
    @XmlElement(name="duedate", type=Iso8601Date.class)
    private Iso8601Date dueDate;

    public FRIValue getBillProviderFRI() {
        return this.billProviderFRI;
    }

    public void setBillProviderFRI(FRIValue billProviderFRI) {
        this.billProviderFRI = billProviderFRI;
    }

    public String getBillProviderDescriptiveName() {
        return this.billProviderDescriptiveName;
    }

    public void setBillProviderDescriptiveName(String billProviderDescriptiveName) {
        this.billProviderDescriptiveName = billProviderDescriptiveName;
    }

    public IdentityValue getAccountHolderIdentity() {
        return this.accountHolderIdentity;
    }

    public void setAccountHolderIdentity(IdentityValue accountHolderIdentity) {
        this.accountHolderIdentity = accountHolderIdentity;
    }

    public FirstnameValue getFirstName() {
        return this.firstName;
    }

    public void setFirstName(FirstnameValue firstName) {
        this.firstName = firstName;
    }

    public SurnameValue getLastName() {
        return this.lastName;
    }

    public void setLastName(SurnameValue lastName) {
        this.lastName = lastName;
    }

    public String getCustomerReference() {
        return this.customerReference;
    }

    public void setCustomerReference(String customerReference) {
        this.customerReference = customerReference;
    }

    public String getBillReference() {
        return this.billReference;
    }

    public void setBillReference(String billReference) {
        this.billReference = billReference;
    }

    public MessageValue getMessage() {
        return this.message;
    }

    public void setMessage(MessageValue message) {
        this.message = message;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public MoneyDetails getAmountPaid() {
        return this.amountPaid;
    }

    public void setAmountPaid(MoneyDetails amountPaid) {
        this.amountPaid = amountPaid;
    }

    public Iso8601Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Iso8601Date dueDate) {
        this.dueDate = dueDate;
    }
}

