/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.billmanager.v1_1.common;

import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.Iso8601Date;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsExternalReferenceString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="billentry", namespace="http://www.ericsson.com/em/emm/billmanager/v1_1/common", propOrder={"billProviderId", "billId", "customerReference", "billReference", "amount", "amountPaid", "dueDate"})
public class BillEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @Min(value=1L)
    @XmlElement(name="billproviderid", required=true)
    private @NotNull @Min(value=1L) Long billProviderId;
    @NotNull
    @Min(value=1L)
    @XmlElement(name="billid", required=true)
    private @NotNull @Min(value=1L) Long billId;
    @Valid
    @IsExternalReferenceString
    @Length(max=50)
    @XmlElement(name="customerreference")
    private String customerReference;
    @Valid
    @IsExternalReferenceString
    @Length(max=50)
    @XmlElement(name="billreference")
    private String billReference;
    @NotNull
    @Valid
    @IsPositiveAmount
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    private MoneyDetails amount;
    @NotNull
    @Valid
    @XmlElement(name="amountpaid", type=MoneyDetails.class, required=true)
    private MoneyDetails amountPaid;
    @Valid
    @XmlElement(name="duedate", type=Iso8601Date.class)
    private Iso8601Date dueDate;

    public Long getBillProviderId() {
        return this.billProviderId;
    }

    public void setBillProviderId(Long billProviderId) {
        this.billProviderId = billProviderId;
    }

    public Long getBillId() {
        return this.billId;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public String getCustomerReference() {
        return this.customerReference;
    }

    public void setCustomerReference(String customerReference) {
        this.customerReference = customerReference;
    }

    public String getBillReference() {
        return this.billReference;
    }

    public void setBillReference(String billReference) {
        this.billReference = billReference;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public MoneyDetails getAmountPaid() {
        return this.amountPaid;
    }

    public void setAmountPaid(MoneyDetails amountPaid) {
        this.amountPaid = amountPaid;
    }

    public Iso8601Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Iso8601Date dueDate) {
        this.dueDate = dueDate;
    }
}

