/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.campaignmanagement.hidden.v1_0.common;

import com.ericsson.em.m3if.campaignmanagement.hidden.v1_0.common.CampaignDescriptionValue;
import com.ericsson.em.m3if.campaignmanagement.hidden.v1_0.common.CampaignId;
import com.ericsson.em.m3if.campaignmanagement.hidden.v1_0.common.CampaignRuleInterpretationValue;
import com.ericsson.em.m3if.campaignmanagement.hidden.v1_0.common.CampaignStatus;
import com.ericsson.em.m3if.campaignmanagement.hidden.v1_0.common.CampaignType;
import com.ericsson.em.m3if.campaignmanagement.hidden.v1_0.common.IndividualRatingParameterRule;
import com.ericsson.em.m3if.v1_0.common.AmountValue;
import com.ericsson.em.m3if.v1_0.common.CurrencyCode;
import com.ericsson.em.m3if.v1_0.common.DateInterval;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.NameValue;
import com.ericsson.em.m3if.v1_0.common.VersionValue;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/campaignmanagement/hidden/v1_0/common", name="campaign")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/campaignmanagement/hidden/v1_0/common", name="", propOrder={"campaignId", "campaignVersion", "campaignType", "status", "name", "description", "currency", "validityDates", "priority", "notificationDisplayName", "createdDateTime", "inactivatedDateTime", "activatedDateTime", "rejectedDateTime", "irpRulesInterpretation", "ratingParameterRules", "budgetAmount"})
public class Campaign
implements Serializable {
    private static final long serialVersionUID = -91180236122343811L;
    @Valid
    @XmlElement(name="campaignid")
    private CampaignId campaignId;
    @Valid
    @XmlElement(name="version")
    private VersionValue campaignVersion;
    @Valid
    @XmlElement(name="campaigntype")
    private CampaignType campaignType;
    @Valid
    @XmlElement(name="status")
    private CampaignStatus status;
    @NotNull
    @Valid
    @XmlElement(name="name", required=true)
    private NameValue name;
    @Valid
    @XmlElement(name="description")
    private CampaignDescriptionValue description;
    @NotNull
    @Valid
    @XmlElement(name="currency", required=true)
    private CurrencyCode currency;
    @Valid
    @NotNull
    @XmlElement(name="validitydates", type=DateInterval.class, required=true)
    private DateInterval validityDates;
    @Min(value=0L)
    @XmlElement(name="priority", defaultValue="0")
    private @Min(value=0L) Integer priority = 0;
    @Valid
    @XmlElement(name="notificationdisplayname")
    private NameValue notificationDisplayName;
    @XmlElement(name="createddatetime")
    @Valid
    private Iso8601DateTime createdDateTime;
    @XmlElement(name="inactivateddatetime")
    @Valid
    private Iso8601DateTime inactivatedDateTime;
    @XmlElement(name="activateddatetime")
    @Valid
    private Iso8601DateTime activatedDateTime;
    @XmlElement(name="rejecteddatetime")
    @Valid
    private Iso8601DateTime rejectedDateTime;
    @Valid
    @XmlElement(name="irprulesinterpretation", type=CampaignRuleInterpretationValue.class, defaultValue="EXCLUDING")
    private CampaignRuleInterpretationValue irpRulesInterpretation = CampaignRuleInterpretationValue.EXCLUDING;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="individualratingparameterrules")
    @XmlElements(value={@XmlElement(name="rule", type=IndividualRatingParameterRule.class)})
    private List<IndividualRatingParameterRule> ratingParameterRules = new ArrayList<IndividualRatingParameterRule>();
    @Valid
    @XmlElement(name="budgetamount", type=AmountValue.class)
    private AmountValue budgetAmount;

    public CampaignId getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(CampaignId campaignId) {
        this.campaignId = campaignId;
    }

    public VersionValue getCampaignVersion() {
        return this.campaignVersion;
    }

    public void setCampaignVersion(VersionValue campaignVersion) {
        this.campaignVersion = campaignVersion;
    }

    public CampaignType getCampaignType() {
        return this.campaignType;
    }

    public void setCampaignType(CampaignType campaignType) {
        this.campaignType = campaignType;
    }

    public CampaignStatus getStatus() {
        return this.status;
    }

    public void setStatus(CampaignStatus status) {
        this.status = status;
    }

    public NameValue getName() {
        return this.name;
    }

    public void setName(NameValue name) {
        this.name = name;
    }

    public CampaignDescriptionValue getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return CampaignDescriptionValue.fromString("");
    }

    public void setDescription(CampaignDescriptionValue description) {
        this.description = description;
    }

    public CurrencyCode getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyCode currency) {
        this.currency = currency;
    }

    public DateInterval getValidityDates() {
        return this.validityDates;
    }

    public void setValidityDates(DateInterval validityDates) {
        this.validityDates = validityDates;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public NameValue getNotificationDisplayName() {
        if (this.notificationDisplayName != null) {
            return this.notificationDisplayName;
        }
        return NameValue.fromString("");
    }

    public void setNotificationDisplayName(NameValue notificationDisplayName) {
        this.notificationDisplayName = notificationDisplayName;
    }

    public Iso8601DateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public void setCreatedDateTime(Iso8601DateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    public Iso8601DateTime getInactivatedDateTime() {
        return this.inactivatedDateTime;
    }

    public void setInactivatedDateTime(Iso8601DateTime inactivatedDateTime) {
        this.inactivatedDateTime = inactivatedDateTime;
    }

    public Iso8601DateTime getActivatedDateTime() {
        return this.activatedDateTime;
    }

    public void setActivatedDateTime(Iso8601DateTime activatedDateTime) {
        this.activatedDateTime = activatedDateTime;
    }

    public Iso8601DateTime getRejectedDateTime() {
        return this.rejectedDateTime;
    }

    public void setRejectedDateTime(Iso8601DateTime rejectedDateTime) {
        this.rejectedDateTime = rejectedDateTime;
    }

    public CampaignRuleInterpretationValue getIrpRulesInterpretation() {
        return this.irpRulesInterpretation;
    }

    public void setIrpRulesInterpretation(CampaignRuleInterpretationValue irpRulesInterpretation) {
        this.irpRulesInterpretation = irpRulesInterpretation;
    }

    public List<IndividualRatingParameterRule> getRatingParameterRules() {
        return this.ratingParameterRules;
    }

    public void setRatingParameterRules(List<IndividualRatingParameterRule> ratingParameterRules) {
        this.ratingParameterRules = ratingParameterRules;
    }

    public AmountValue getBudgetAmount() {
        if (this.budgetAmount != null) {
            return this.budgetAmount;
        }
        return AmountValue.ZERO;
    }

    public void setBudgetAmount(AmountValue budgetAmount) {
        this.budgetAmount = budgetAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Campaign campaign = (Campaign)o;
        return Objects.equals(this.campaignId, campaign.campaignId) && Objects.equals(this.campaignVersion, campaign.campaignVersion) && this.campaignType == campaign.campaignType && this.status == campaign.status && Objects.equals(this.name, campaign.name) && Objects.equals(this.description, campaign.description) && Objects.equals(this.currency, campaign.currency) && Objects.equals(this.validityDates, campaign.validityDates) && Objects.equals(this.priority, campaign.priority) && Objects.equals(this.notificationDisplayName, campaign.notificationDisplayName) && Objects.equals(this.createdDateTime, campaign.createdDateTime) && Objects.equals(this.inactivatedDateTime, campaign.inactivatedDateTime) && Objects.equals(this.activatedDateTime, campaign.activatedDateTime) && Objects.equals(this.rejectedDateTime, campaign.rejectedDateTime) && this.irpRulesInterpretation == campaign.irpRulesInterpretation && Objects.equals(this.ratingParameterRules, campaign.ratingParameterRules) && Objects.equals(this.budgetAmount, campaign.budgetAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.campaignId, this.campaignVersion, this.campaignType, this.status, this.name, this.description, this.currency, this.validityDates, this.priority, this.notificationDisplayName, this.createdDateTime, this.inactivatedDateTime, this.activatedDateTime, this.rejectedDateTime, this.irpRulesInterpretation, this.ratingParameterRules, this.budgetAmount});
    }

    public String toString() {
        return "Campaign{campaignId=" + String.valueOf(this.campaignId) + ", campaignVersion=" + String.valueOf(this.campaignVersion) + ", campaignType=" + String.valueOf((Object)this.campaignType) + ", status=" + String.valueOf((Object)this.status) + ", name=" + String.valueOf(this.name) + ", description=" + String.valueOf(this.description) + ", currency=" + String.valueOf(this.currency) + ", validityDates=" + String.valueOf(this.validityDates) + ", priority=" + this.priority + ", notificationDisplayName=" + String.valueOf(this.notificationDisplayName) + ", createdDateTime=" + String.valueOf(this.createdDateTime) + ", inactivatedDateTime=" + String.valueOf(this.inactivatedDateTime) + ", activatedDateTime=" + String.valueOf(this.activatedDateTime) + ", rejectedDateTime=" + String.valueOf(this.rejectedDateTime) + ", irpRulesInterpretation=" + String.valueOf((Object)this.irpRulesInterpretation) + ", ratingParameterRules=" + String.valueOf(this.ratingParameterRules) + ", budgetAmount=" + String.valueOf(this.budgetAmount) + "}";
    }
}

