/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.card.v1_0.common;

import com.ericsson.em.emm.util.AbstractValueObject;
import com.ericsson.em.emm.util.SensitiveValueObject;
import com.ericsson.em.emm.util.ValueObject;
import com.ericsson.em.validators.IsNumericString;
import com.ericsson.em.validators.Length;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/card/v1_0/common", name="cardnumber")
public final class CardNumberValue
extends SensitiveValueObject
implements Comparable<AbstractValueObject>,
Serializable,
ValueObject {
    private static final long serialVersionUID = 1L;
    private static final Pattern MASK_PATTERN = Pattern.compile("^(.*)(?:[0-9]{4})$");
    @NotNull
    @IsNumericString
    @Length(min=8, max=24)
    @XmlValue
    private String value;

    private CardNumberValue() {
    }

    private CardNumberValue(String value) {
        this.value = value;
    }

    public static CardNumberValue fromString(String value) {
        if (value == null) {
            return null;
        }
        return new CardNumberValue(value);
    }

    @Override
    public Pattern getRegexToMaskWith() {
        return MASK_PATTERN;
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }
}

