/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.coupons.v1_1.common;

import com.ericsson.em.m3if.coupons.v1_0.common.Awarder;
import com.ericsson.em.m3if.coupons.v1_0.common.CouponOfferStatus;
import com.ericsson.em.m3if.coupons.v1_0.common.Reward;
import com.ericsson.em.m3if.coupons.v1_0.common.RewardType;
import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.ProfileName;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsMSISDN;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsSingleWordString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/coupons/v1_1/common", name="couponofferdetails", propOrder={"offerId", "issuer", "startDate", "endDate", "couponsValidityDays", "description", "totalCoupons", "couponsPerUser", "fundingAccountFRI", "userProfiles", "minimumPurchaseAmount", "maximumPurchaseAmount", "reward", "rewardType", "status", "awarders", "totalAmountRedeemable", "identityListUploaded", "uploadedIdentitiesCount"})
public class CouponOfferDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotBlank
    @IsSingleWordString
    @XmlElement(name="offerid", required=true)
    private String offerId;
    @IsMSISDN
    @NotNull
    @XmlElement(name="issuer", required=true)
    private String issuer;
    @NotNull
    @XmlElement(name="startdate", required=true)
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date startDate;
    @NotNull
    @XmlElement(name="enddate", required=true)
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date endDate;
    @Min(value=0L)
    @XmlElement(name="couponsvaliditydays")
    private @Min(value=0L) Integer couponsValidityDays;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="totalcoupons")
    private Long totalCoupons;
    @XmlElement(name="couponsperuser")
    private Long couponsPerUser;
    @IsFinancialResourceIdentifier
    @XmlElement(name="fundingaccountfri")
    private String fundingAccountFRI;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="userprofiles")
    @XmlElements(value={@XmlElement(name="userprofile", type=ProfileName.class)})
    private List<ProfileName> userProfiles;
    @Valid
    @XmlElement(name="minimumpurchaseamount", type=MoneyDetails.class)
    @IsPositiveAmount
    private MoneyDetails minimumPurchaseAmount;
    @Valid
    @XmlElement(name="maximumpurchaseamount", type=MoneyDetails.class)
    @IsPositiveAmount
    private MoneyDetails maximumPurchaseAmount;
    @Valid
    @NotNull
    @XmlElement(name="reward", required=true, type=Reward.class)
    private Reward reward;
    @NotNull
    @XmlElement(name="rewardtype", required=true)
    private RewardType rewardType;
    @XmlElement(name="status")
    private CouponOfferStatus status;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="awarders")
    @XmlElements(value={@XmlElement(name="awarder", type=Awarder.class)})
    private List<Awarder> awarders;
    @Valid
    @XmlElement(name="totalamountredeemable", type=MoneyDetails.class)
    @IsPositiveAmount
    private MoneyDetails totalAmountRedeemable;
    @XmlElement(name="identitylistuploaded", defaultValue="false")
    private Boolean identityListUploaded = false;
    @Min(value=0L)
    @XmlElement(name="uploadedidentitiescount")
    private @Min(value=0L) Long uploadedIdentitiesCount;

    public String getOfferId() {
        return this.offerId;
    }

    public void setOfferId(String offerId) {
        this.offerId = offerId;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public DateTime getStartDate() {
        return this.startDate == null ? null : new DateTime(this.startDate);
    }

    public void setStartDate(DateTime startDate) {
        this.startDate = startDate == null ? null : startDate.toDate();
    }

    public DateTime getEndDate() {
        return this.endDate == null ? null : new DateTime(this.endDate);
    }

    public void setEndDate(DateTime endDate) {
        this.endDate = endDate == null ? null : endDate.toDate();
    }

    public Integer getCouponsValidityDays() {
        return this.couponsValidityDays;
    }

    public void setCouponsValidityDays(Integer couponsValidityDays) {
        this.couponsValidityDays = couponsValidityDays;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getTotalCoupons() {
        return this.totalCoupons;
    }

    public void setTotalCoupons(Long totalCoupons) {
        this.totalCoupons = totalCoupons;
    }

    public Long getCouponsPerUser() {
        return this.couponsPerUser;
    }

    public void setCouponsPerUser(Long couponsPerUser) {
        this.couponsPerUser = couponsPerUser;
    }

    public String getFundingAccountFRI() {
        return this.fundingAccountFRI;
    }

    public void setFundingAccountFRI(String fundingAccountFRI) {
        this.fundingAccountFRI = fundingAccountFRI;
    }

    public List<ProfileName> getUserProfiles() {
        return this.userProfiles;
    }

    public void setUserProfiles(List<ProfileName> userProfiles) {
        this.userProfiles = userProfiles;
    }

    public MoneyDetails getMinimumPurchaseAmount() {
        return this.minimumPurchaseAmount;
    }

    public void setMinimumPurchaseAmount(MoneyDetails minimumPurchaseAmount) {
        this.minimumPurchaseAmount = minimumPurchaseAmount;
    }

    public MoneyDetails getMaximumPurchaseAmount() {
        return this.maximumPurchaseAmount;
    }

    public void setMaximumPurchaseAmount(MoneyDetails maximumPurchaseAmount) {
        this.maximumPurchaseAmount = maximumPurchaseAmount;
    }

    public Reward getReward() {
        return this.reward;
    }

    public void setReward(Reward reward) {
        this.reward = reward;
    }

    public RewardType getRewardType() {
        return this.rewardType;
    }

    public void setRewardType(RewardType rewardType) {
        this.rewardType = rewardType;
    }

    public CouponOfferStatus getStatus() {
        return this.status;
    }

    public void setStatus(CouponOfferStatus offerStatus) {
        this.status = offerStatus;
    }

    public List<Awarder> getAwarders() {
        return this.awarders;
    }

    public void setAwarders(List<Awarder> awarders) {
        this.awarders = awarders;
    }

    public MoneyDetails getTotalAmountRedeemable() {
        return this.totalAmountRedeemable;
    }

    public void setTotalAmountRedeemable(MoneyDetails totalAmountRedeemable) {
        this.totalAmountRedeemable = totalAmountRedeemable;
    }

    public Boolean getIdentityListUploaded() {
        return this.identityListUploaded;
    }

    public void setIdentityListUploaded(Boolean identityListUploaded) {
        this.identityListUploaded = identityListUploaded;
    }

    public Long getUploadedIdentitiesCount() {
        return this.uploadedIdentitiesCount;
    }

    public void setUploadedIdentitiesCount(Long uploadedIdentitiesCount) {
        this.uploadedIdentitiesCount = uploadedIdentitiesCount;
    }
}

