/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.externalinstrument.v1_0.common;

import com.ericsson.em.emm.util.AbstractValueObject;
import com.ericsson.em.emm.util.SensitiveValueObject;
import com.ericsson.em.emm.util.ValueObject;
import com.ericsson.em.validators.IsExternalReferenceString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/externalinstrument/v1_0/common", name="instrumentreference")
public class InstrumentReference
extends SensitiveValueObject
implements Comparable<AbstractValueObject>,
Serializable,
ValueObject {
    private static final long serialVersionUID = 1L;
    private static final Pattern MASK_PATTERN = Pattern.compile("(.+)(?=.{4})");
    @Length(max=64)
    @IsExternalReferenceString
    @NotNull
    @NotBlank
    @XmlValue
    private final String value;

    protected InstrumentReference() {
        this.value = null;
    }

    private InstrumentReference(String value) {
        this.value = value;
    }

    public static InstrumentReference fromString(String value) {
        if (value == null) {
            return null;
        }
        return new InstrumentReference(value);
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    public static Optional<String> asString(InstrumentReference value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(value.getValueAsString());
    }

    @Override
    public Pattern getRegexToMaskWith() {
        return MASK_PATTERN;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstrumentReference other = (InstrumentReference)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

