/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_0.common;

import com.ericsson.em.m3if.financial.v1_0.common.TaxDetail;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_0/common", name="quotedetails", propOrder={"fri", "sendAmount", "feeFri", "fee", "taxDetails"})
public class QuoteDetails {
    @Valid
    @NotNull
    @XmlElement(name="fri", required=true)
    private FRIValue fri;
    @Valid
    @XmlElement(name="sendamount", type=MoneyDetails.class)
    private MoneyDetails sendAmount;
    @Valid
    @XmlElement(name="feefri", type=FRIValue.class)
    private FRIValue feeFri;
    @Valid
    @XmlElement(name="fee", type=MoneyDetails.class)
    @IsPositiveAmount
    private MoneyDetails fee;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="taxdetails")
    @XmlElements(value={@XmlElement(name="taxdetail", required=true, type=TaxDetail.class)})
    private List<TaxDetail> taxDetails;

    public FRIValue getFri() {
        return this.fri;
    }

    public void setFri(FRIValue fri) {
        this.fri = fri;
    }

    public Optional<MoneyDetails> getSendAmount() {
        return Optional.ofNullable(this.sendAmount);
    }

    public void setSendAmount(MoneyDetails sendAmount) {
        this.sendAmount = sendAmount;
    }

    public Optional<FRIValue> getFeeFri() {
        return Optional.ofNullable(this.feeFri);
    }

    public void setFeeFri(FRIValue feeFri) {
        this.feeFri = feeFri;
    }

    public void setFeeFri(String feeFri) {
        this.feeFri = FRIValue.fromString(feeFri);
    }

    public Optional<MoneyDetails> getFee() {
        return Optional.ofNullable(this.fee);
    }

    public void setFee(MoneyDetails fee) {
        this.fee = fee;
    }

    public List<TaxDetail> getTaxDetails() {
        return this.taxDetails;
    }

    public void setTaxDetails(List<TaxDetail> taxDetails) {
        this.taxDetails = taxDetails;
    }
}

