/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_0.common;

import com.ericsson.em.m3if.financial.v1_0.common.Direction;
import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.Argument;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_1.common.TransferType;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsMultiWordString;
import com.ericsson.em.validators.IsNumericString;
import com.ericsson.em.validators.IsSingleWordString;
import com.ericsson.em.validators.IsUsername;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_0/common", name="rejectedcustodyaccounttransactionentry", propOrder={"financialTransactionId", "transferType", "startDate", "initiatingUser", "realUser", "initiatingAccountHolder", "realAccountHolder", "direction", "from", "fromAccount", "fromAmount", "fromFee", "fromDiscount", "fromPromotion", "to", "toAccount", "toAmount", "toFee", "toPromotion", "cause", "reason", "arguments"})
public class RejectedCustodyAccountTransactionEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    @IsNumericString
    @XmlElement(name="financialtransactionid")
    private String financialTransactionId = null;
    @XmlElement(name="transfertype")
    private TransferType transferType;
    @XmlElement(name="startdate")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date startDate;
    @IsUsername
    @XmlElement(name="initiatinguser")
    private String initiatingUser;
    @IsUsername
    @XmlElement(name="realuser")
    private String realUser;
    @IsIdentity
    @XmlElement(name="initiatingaccountholder")
    private String initiatingAccountHolder;
    @IsIdentity
    @XmlElement(name="realaccountholder")
    private String realAccountHolder;
    @XmlElement(name="direction")
    private Direction direction;
    @IsFinancialResourceIdentifier
    @XmlElement(name="from")
    private String from;
    @IsFinancialResourceIdentifier
    @XmlElement(name="fromaccount")
    private String fromAccount;
    @Valid
    @XmlElement(name="fromamount")
    @IsPositiveAmount
    private MoneyDetails fromAmount;
    @Valid
    @XmlElement(name="fromfee")
    @IsPositiveAmount
    private MoneyDetails fromFee;
    @Valid
    @XmlElement(name="fromdiscount")
    @IsPositiveAmount
    private MoneyDetails fromDiscount;
    @Valid
    @XmlElement(name="frompromotion")
    @IsPositiveAmount
    private MoneyDetails fromPromotion;
    @IsFinancialResourceIdentifier
    @XmlElement(name="to")
    private String to;
    @IsFinancialResourceIdentifier
    @XmlElement(name="toaccount")
    private String toAccount;
    @Valid
    @XmlElement(name="toamount")
    @IsPositiveAmount
    private MoneyDetails toAmount;
    @Valid
    @XmlElement(name="tofee")
    @IsPositiveAmount
    private MoneyDetails toFee;
    @Valid
    @XmlElement(name="topromotion")
    @IsPositiveAmount
    private MoneyDetails toPromotion;
    @IsMultiWordString
    @XmlElement(name="cause")
    private String cause;
    @NotNull
    @IsSingleWordString
    @XmlElement(name="reason")
    private String reason;
    @Valid
    @NotNull
    @NoNullElements
    @XmlElementWrapper(name="arguments")
    @XmlElements(value={@XmlElement(name="argument", type=Argument.class)})
    private final List<Argument> arguments = new LinkedList<Argument>();

    public String getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(String financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public DateTime getStartDate() {
        return DateHelper.fromDate(this.startDate);
    }

    public void setStartDate(DateTime startDate) {
        this.startDate = DateHelper.toDate(startDate);
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String source) {
        this.from = source;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String target) {
        this.to = target;
    }

    public String getFromAccount() {
        return this.fromAccount;
    }

    public void setFromAccount(String fromAccount) {
        this.fromAccount = fromAccount;
    }

    public MoneyDetails getFromAmount() {
        return this.fromAmount;
    }

    public void setFromAmount(MoneyDetails fromAmount) {
        this.fromAmount = fromAmount;
    }

    public String getToAccount() {
        return this.toAccount;
    }

    public void setToAccount(String toAccount) {
        this.toAccount = toAccount;
    }

    public MoneyDetails getToAmount() {
        return this.toAmount;
    }

    public void setToAmount(MoneyDetails toAmount) {
        this.toAmount = toAmount;
    }

    public String getInitiatingUser() {
        return this.initiatingUser;
    }

    public void setInitiatingUser(String initiatingUser) {
        this.initiatingUser = initiatingUser;
    }

    public String getRealUser() {
        return this.realUser;
    }

    public void setRealUser(String real) {
        this.realUser = real;
    }

    public String getInitiatingAccountHolder() {
        return this.initiatingAccountHolder;
    }

    public void setInitiatingAccountHolder(String initiatingAccountHolder) {
        this.initiatingAccountHolder = initiatingAccountHolder;
    }

    public String getRealAccountHolder() {
        return this.realAccountHolder;
    }

    public void setRealAccountHolder(String realAccountHolder) {
        this.realAccountHolder = realAccountHolder;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public MoneyDetails getFromFee() {
        return this.fromFee;
    }

    public void setFromFee(MoneyDetails fromFee) {
        this.fromFee = fromFee;
    }

    public MoneyDetails getFromDiscount() {
        return this.fromDiscount;
    }

    public void setFromDiscount(MoneyDetails fromDiscount) {
        this.fromDiscount = fromDiscount;
    }

    public MoneyDetails getFromPromotion() {
        return this.fromPromotion;
    }

    public void setFromPromotion(MoneyDetails fromPromotion) {
        this.fromPromotion = fromPromotion;
    }

    public MoneyDetails getToFee() {
        return this.toFee;
    }

    public void setToFee(MoneyDetails toFee) {
        this.toFee = toFee;
    }

    public MoneyDetails getToPromotion() {
        return this.toPromotion;
    }

    public void setToPromotion(MoneyDetails toPromotion) {
        this.toPromotion = toPromotion;
    }

    public String getCause() {
        return this.cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public void addArgument(Argument argument) {
        if (argument != null) {
            this.arguments.add(argument);
        }
    }

    public void addArgument(String name, String value) {
        if (name != null && value != null) {
            this.arguments.add(new Argument(name, value));
        }
    }

    public void addArgument(String name, int value) {
        if (name != null) {
            this.arguments.add(new Argument(name, String.valueOf(value)));
        }
    }

    public void addArgument(String name, BigDecimal value) {
        if (name != null && value != null) {
            this.arguments.add(new Argument(name, value.toPlainString()));
        }
    }

    public void addArgument(String name, MoneyDetails value) {
        if (name != null && value != null) {
            this.arguments.add(new Argument(name, value));
        }
    }
}

