/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_0.common;

import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.ScheduledTransactionDate;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsRestrictedString;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_0/common", name="scheduledtransaction", propOrder={"scheduledTransactionId", "fromFri", "toFri", "amount", "fromMessage", "toMessage", "financialOperation", "scheduleDate"})
@Deprecated
public class ScheduledTransaction
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="scheduledtransactionid", required=true)
    private Long scheduledTransactionId;
    @IsFinancialResourceIdentifier
    @XmlElement(name="fromfri", required=true)
    private String fromFri;
    @IsFinancialResourceIdentifier
    @XmlElement(name="tofri", required=true)
    private String toFri;
    @Valid
    @NotNull
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @IsRestrictedString
    @XmlElement(name="frommessage")
    private String fromMessage;
    @IsRestrictedString
    @XmlElement(name="tomessage")
    private String toMessage;
    @IsRestrictedString
    @XmlElement(name="financialoperation", required=true)
    private String financialOperation;
    @Valid
    @XmlElement(name="scheduledate", type=ScheduledTransactionDate.class, required=true)
    @NotNull
    private ScheduledTransactionDate scheduleDate;

    public Long getScheduledTransactionId() {
        return this.scheduledTransactionId;
    }

    public void setScheduledTransactionId(Long scheduledTransactionId) {
        this.scheduledTransactionId = scheduledTransactionId;
    }

    public String getFromFri() {
        return this.fromFri;
    }

    public void setFromFri(String fromFri) {
        this.fromFri = fromFri;
    }

    public String getToFri() {
        return this.toFri;
    }

    public void setToFri(String toFri) {
        this.toFri = toFri;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getFromMessage() {
        return this.fromMessage;
    }

    public void setFromMessage(String fromMessage) {
        this.fromMessage = fromMessage;
    }

    public String getToMessage() {
        return this.toMessage;
    }

    public void setToMessage(String toMessage) {
        this.toMessage = toMessage;
    }

    public String getFinancialOperation() {
        return this.financialOperation;
    }

    public void setFinancialOperation(String financialOperation) {
        this.financialOperation = financialOperation;
    }

    public ScheduledTransactionDate getScheduleDate() {
        return this.scheduleDate;
    }

    public DateTime getScheduleDateAsDate() {
        return this.scheduleDate == null ? null : this.scheduleDate.getDate().toDateTime();
    }

    public void setScheduleDate(ScheduledTransactionDate scheduleDate) {
        this.scheduleDate = scheduleDate;
    }

    public void setScheduleDate(DateTime schedule) {
        this.scheduleDate = new ScheduledTransactionDate(schedule);
    }
}

