/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_0.initiatecashin;

import com.ericsson.em.m3if.financial.v1_0.quotation.Assistable;
import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.ClientReferenceIdValue;
import com.ericsson.em.m3if.v1_0.common.ExternalTransactionIdValue;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.IsSenderChargesIncluded;
import com.ericsson.em.m3if.v1_0.common.MessageValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="initiatecashinrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="", propOrder={"sendingFRI", "receivingFRI", "amount", "senderNote", "receiverMessage", "quoteId", "isSenderChargesIncluded", "clientReferenceId", "externalTransactionId"})
public class InitiateCashInRequest
implements Serializable,
QuoteRequest,
Assistable {
    private static final long serialVersionUID = 1L;
    @Valid
    @NotNull
    @XmlElement(name="sendingfri", type=FRIValue.class, required=true)
    private FRIValue sendingFRI;
    @Valid
    @XmlElement(name="receivingfri", type=FRIValue.class, required=false)
    private FRIValue receivingFRI;
    @Valid
    @NotNull
    @IsPositiveAmount
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    private MoneyDetails amount;
    @Valid
    @XmlElement(name="sendernote", type=MessageValue.class, required=false)
    private MessageValue senderNote;
    @Valid
    @XmlElement(name="receivermessage", type=MessageValue.class, required=false)
    private MessageValue receiverMessage;
    @Valid
    @XmlElement(name="quoteid", type=QuoteId.class, required=false)
    private QuoteId quoteId;
    @Valid
    @XmlElement(name="issenderchargesincluded", type=IsSenderChargesIncluded.class, required=false)
    private IsSenderChargesIncluded isSenderChargesIncluded = IsSenderChargesIncluded.fromBoolean(false);
    @Valid
    @XmlElement(name="clientreferenceid", type=ClientReferenceIdValue.class)
    private ClientReferenceIdValue clientReferenceId;
    @Valid
    @XmlElement(name="externaltransactionid", type=ExternalTransactionIdValue.class)
    private ExternalTransactionIdValue externalTransactionId;

    public InitiateCashInRequest() {
    }

    public InitiateCashInRequest(FRIValue from, FRIValue to, MoneyDetails amount) {
        this();
        this.sendingFRI = from;
        this.receivingFRI = to;
        this.amount = amount;
    }

    public InitiateCashInRequest(FRIValue from, FRIValue to, MoneyDetails amount, MessageValue senderNote, MessageValue receiverMessage) {
        this(from, to, amount);
        this.senderNote = senderNote;
        this.receiverMessage = receiverMessage;
    }

    public FRIValue getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(FRIValue from) {
        this.sendingFRI = from;
    }

    public Optional<FRIValue> getReceivingFRI() {
        return Optional.ofNullable(this.receivingFRI);
    }

    public void setReceivingFRI(FRIValue to) {
        this.receivingFRI = to;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public Optional<MessageValue> getSenderNote() {
        return Optional.ofNullable(this.senderNote);
    }

    public void setSenderNote(MessageValue senderNote) {
        this.senderNote = senderNote;
    }

    public Optional<MessageValue> getReceiverMessage() {
        return Optional.ofNullable(this.receiverMessage);
    }

    public void setReceiverMessage(MessageValue receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public Optional<IsSenderChargesIncluded> getIsSenderChargesIncluded() {
        return Optional.ofNullable(this.isSenderChargesIncluded);
    }

    public void setIsSenderChargesIncluded(IsSenderChargesIncluded isSenderChargesIncluded) {
        this.isSenderChargesIncluded = isSenderChargesIncluded;
    }

    public Optional<ClientReferenceIdValue> getClientReferenceId() {
        return Optional.ofNullable(this.clientReferenceId);
    }

    public void setClientReferenceId(ClientReferenceIdValue clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    public Optional<ExternalTransactionIdValue> getExternalTransactionId() {
        return Optional.ofNullable(this.externalTransactionId);
    }

    public void setExternalTransactionId(ExternalTransactionIdValue externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }
}

