/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_0.transfer;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.v1_0.common.ExtensionType;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v1_0.common.ScheduledTransactionDate;
import com.ericsson.em.validators.IsAmount;
import com.ericsson.em.validators.IsExternalReferenceString;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="transferrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="", propOrder={"sendingFRI", "receivingFRI", "amount", "senderNote", "receiverMessage", "referenceId", "scheduled", "extension", "quoteId"})
public class TransferRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.0";
    @IsFinancialResourceIdentifier
    @XmlElement(name="sendingfri")
    private String sendingFRI;
    @NotNull
    @IsFinancialResourceIdentifier
    @XmlElement(name="receivingfri", required=true)
    private String receivingFRI;
    @IsAmount(allowNull=false)
    @XmlElement(name="amount", required=true)
    private BigDecimal amount;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="sendernote")
    private String senderNote;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="receivermessage")
    private String receiverMessage;
    @Length(min=1, max=64)
    @IsExternalReferenceString
    @XmlElement(name="referenceid")
    private String referenceId;
    @Valid
    @XmlElement(name="scheduled", type=ScheduledTransactionDate.class)
    private ScheduledTransactionDate scheduled;
    @Valid
    @XmlElement(name="extension")
    private ExtensionType extension;
    @Valid
    @XmlElement(name="quoteid", type=QuoteId.class)
    private QuoteId quoteId;

    public TransferRequest() {
    }

    public TransferRequest(String sendingFRI, String receivingFRI, BigDecimal amount) {
        this.setSendingFRI(sendingFRI);
        this.setReceivingFRI(receivingFRI);
        this.setAmount(amount);
    }

    public TransferRequest(String sendingFRI, String receivingFRI, BigDecimal amount, String senderNote, String receiverMessage, String referenceId, ExtensionType extension) {
        this(sendingFRI, receivingFRI, amount);
        this.setSenderNote(senderNote);
        this.setReceiverMessage(receiverMessage);
        this.setReferenceId(referenceId);
        this.setExtension(extension);
    }

    public String getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(String sendingFRI) {
        this.sendingFRI = sendingFRI;
    }

    public String getReceivingFRI() {
        return this.receivingFRI;
    }

    public void setReceivingFRI(String receivingFRI) {
        this.receivingFRI = receivingFRI;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getSenderNote() {
        return this.senderNote;
    }

    public void setSenderNote(String senderNote) {
        this.senderNote = senderNote;
    }

    public String getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(String receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public ScheduledTransactionDate getScheduled() {
        return this.scheduled;
    }

    public void setScheduled(ScheduledTransactionDate scheduled) {
        this.scheduled = scheduled;
    }

    public ExtensionType getExtension() {
        return this.extension;
    }

    public void setExtension(ExtensionType extension) {
        this.extension = extension;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }
}

