/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_0.transfertobankaccount;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.approvals.ExpiredApprovalAware;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.validators.IsAmount;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="transfertobankaccountrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="", propOrder={"sendingIdentity", "sendingFRI", "amount", "senderNote", "receiverMessage", "quoteId"})
public class TransferToBankAccountRequest
implements Serializable,
QuoteRequest,
ExpiredApprovalAware {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.0";
    @IsIdentity
    @XmlElement(name="sendingidentity")
    private String sendingIdentity;
    @IsAmount(allowNull=false)
    @XmlElement(name="amount", required=true)
    private BigDecimal amount;
    @IsFinancialResourceIdentifier
    @XmlElement(name="sendingfri")
    private String sendingFRI;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="sendernote", required=false)
    private String senderNote;
    @Length(max=100)
    @IsRestrictedString
    @XmlElement(name="receivermessage", required=false)
    private String receiverMessage;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;

    public TransferToBankAccountRequest() {
    }

    public TransferToBankAccountRequest(String sendingIdentity, BigDecimal amount) {
        this.sendingIdentity = sendingIdentity;
        this.amount = amount;
    }

    public String getSendingIdentity() {
        return this.sendingIdentity;
    }

    public void setSendingIdentity(String sendingIdentity) {
        this.sendingIdentity = sendingIdentity;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(String sendingFRI) {
        this.sendingFRI = sendingFRI;
    }

    public String getSenderNote() {
        return this.senderNote;
    }

    public void setSenderNote(String senderNote) {
        this.senderNote = senderNote;
    }

    public String getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(String receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    @Override
    public Optional<String> getSendingFri() {
        return Optional.ofNullable(this.sendingFRI);
    }

    @Override
    public Optional<String> getReceivingFri() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getSupplementaryData() {
        return Optional.ofNullable(this.sendingIdentity == null ? null : "Sending identity: " + this.sendingIdentity);
    }
}

