/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_4.getcustodyaccounttransactionhistory;

import com.ericsson.em.m3if.financial.v1_0.common.Direction;
import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.v1_0.common.BankAccountIdentifier;
import com.ericsson.em.m3if.v1_0.common.DateTimeInterval;
import com.ericsson.em.m3if.v1_0.common.ExternalTransactionIdValue;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionStatus;
import com.ericsson.em.m3if.v1_0.common.IndexOffset;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.MaximumNumberOfEntries;
import com.ericsson.em.m3if.v1_0.common.PagingInfo;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v2_1.common.FinancialInstructionType;
import com.ericsson.em.validators.IsPositiveLong;
import com.ericsson.em.validators.NoNullElements;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_4", name="getcustodyaccounttransactionhistoryrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_4", name="", propOrder={"custodyAccountIdentifier", "pagingInfo", "financialTransactionId", "externalTransactionId", "transactionStatus", "financialInstructionTypes", "transactionCreatedInterval", "transactionFinalizedInterval", "direction", "otherFri", "quoteId"})
public class GetCustodyAccountTransactionHistoryRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MAXLIMIT = 50;
    @NotNull
    @Valid
    @XmlElement(name="custodyaccountidentifier", required=true)
    private BankAccountIdentifier custodyAccountIdentifier;
    @Valid
    @XmlElement(name="paginginfo")
    private PagingInfo pagingInfo;
    @IsPositiveLong(allowZero=false)
    @XmlElement(name="financialtransactionid")
    private Long financialTransactionId;
    @Valid
    @XmlElement(name="externaltransactionid")
    private ExternalTransactionIdValue externalTransactionId;
    @XmlElement(name="transactionstatus")
    private FinancialTransactionStatus transactionStatus;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="financialinstructiontypes", required=true)
    @XmlElements(value={@XmlElement(name="financialinstructiontype", type=FinancialInstructionType.class)})
    private List<FinancialInstructionType> financialInstructionTypes = new LinkedList<FinancialInstructionType>();
    @Valid
    @XmlElement(name="transactioncreatedinterval")
    private DateTimeInterval transactionCreatedInterval;
    @Valid
    @XmlElement(name="transactionfinalizedinterval")
    private DateTimeInterval transactionFinalizedInterval;
    @XmlElement(name="direction")
    private Direction direction;
    @Valid
    @XmlElement(name="otherfri")
    private FRIValue otherFri;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;

    public GetCustodyAccountTransactionHistoryRequest() {
        this.pagingInfo = PagingInfo.from(MaximumNumberOfEntries.fromInteger(50));
    }

    public GetCustodyAccountTransactionHistoryRequest(String bankCode, String accountNumber) {
        this.setCustodyAccountIdentifier(BankAccountIdentifier.from(bankCode, accountNumber));
        this.pagingInfo = PagingInfo.from(MaximumNumberOfEntries.fromInteger(50));
    }

    public GetCustodyAccountTransactionHistoryRequest(String bankCode, String accountNumber, int maxLimit) {
        this.setCustodyAccountIdentifier(BankAccountIdentifier.from(bankCode, accountNumber));
        this.pagingInfo = PagingInfo.from(MaximumNumberOfEntries.fromInteger(maxLimit));
    }

    public GetCustodyAccountTransactionHistoryRequest(String bankCode, String accountNumber, DateTime dateFrom, DateTime dateTo, int maxLimit, int indexOffset) {
        this.setCustodyAccountIdentifier(BankAccountIdentifier.from(bankCode, accountNumber));
        this.transactionFinalizedInterval = DateTimeInterval.from(Iso8601DateTime.fromDateTime(dateFrom), Iso8601DateTime.fromDateTime(dateTo));
        this.pagingInfo = PagingInfo.from(MaximumNumberOfEntries.fromInteger(maxLimit), IndexOffset.fromInteger(indexOffset));
    }

    public BankAccountIdentifier getCustodyAccountIdentifier() {
        return this.custodyAccountIdentifier;
    }

    public void setCustodyAccountIdentifier(BankAccountIdentifier custodyAccountIdentifier) {
        this.custodyAccountIdentifier = custodyAccountIdentifier;
    }

    public PagingInfo getPagingInfo() {
        return this.pagingInfo;
    }

    public void setPagingInfo(PagingInfo pagingInfo) {
        this.pagingInfo = pagingInfo;
    }

    public Optional<Long> getFinancialTransactionId() {
        return Optional.ofNullable(this.financialTransactionId);
    }

    public void setFinancialTransactionId(Long financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public Optional<ExternalTransactionIdValue> getExternalTransactionId() {
        return Optional.ofNullable(this.externalTransactionId);
    }

    public void setExternalTransactionId(ExternalTransactionIdValue externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }

    public Optional<FinancialTransactionStatus> getTransactionStatus() {
        return Optional.ofNullable(this.transactionStatus);
    }

    public void setTransactionStatus(FinancialTransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public List<FinancialInstructionType> getFinancialInstructionTypes() {
        return this.financialInstructionTypes;
    }

    public void addFinancialInstructionType(FinancialInstructionType financialInstructionType) {
        this.financialInstructionTypes.add(financialInstructionType);
    }

    public void setFinancialInstructionTypes(List<FinancialInstructionType> financialInstructionTypes) {
        this.financialInstructionTypes = financialInstructionTypes;
    }

    public Optional<DateTimeInterval> getTransactionCreatedInterval() {
        return Optional.ofNullable(this.transactionCreatedInterval);
    }

    public void setTransactionCreatedInterval(DateTimeInterval transactionCreatedInterval) {
        this.transactionCreatedInterval = transactionCreatedInterval;
    }

    public Optional<DateTimeInterval> getTransactionFinalizedInterval() {
        return Optional.ofNullable(this.transactionFinalizedInterval);
    }

    public void setTransactionFinalizedInterval(DateTimeInterval transactionFinalizedInterval) {
        this.transactionFinalizedInterval = transactionFinalizedInterval;
    }

    public Optional<Direction> getDirection() {
        return Optional.ofNullable(this.direction);
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public Optional<FRIValue> getOtherFri() {
        return Optional.ofNullable(this.otherFri);
    }

    public void setOtherFri(FRIValue otherFri) {
        this.otherFri = otherFri;
    }

    @Override
    @Nullable
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }
}

