/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_5.reversetransaction;

import com.ericsson.em.m3if.financial.v1_0.common.ReverseCountersValue;
import com.ericsson.em.m3if.financial.v1_5.common.ReverseInstruction;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.validators.IsPositiveLong;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import com.ericsson.em.validators.NotEmpty;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_5", name="reversetransactionrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_5", name="", propOrder={"financialTransactionId", "comment", "reverseCounters", "financialInstructionDetails", "receivingFRI"})
public class ReverseTransactionRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @IsPositiveLong(allowNull=false, allowZero=false)
    @XmlElement(name="financialtransactionid", required=true)
    private Long financialTransactionId;
    @NotEmpty
    @Length(max=512)
    @IsRestrictedString
    @XmlElement(name="comment", required=true)
    private String comment;
    @Valid
    @XmlElement(name="reversecounters", type=ReverseCountersValue.class, defaultValue="REVERSE")
    private ReverseCountersValue reverseCounters = ReverseCountersValue.REVERSE;
    @Valid
    @NotEmpty
    @NoNullElements
    @XmlElement(name="financialinstructiondetails", type=ReverseInstruction.class, required=true)
    private List<ReverseInstruction> financialInstructionDetails = new LinkedList<ReverseInstruction>();
    @XmlTransient
    protected Long reverseFinancialTransactionId;
    @Valid
    @XmlElement(name="receivingfri", type=FRIValue.class, required=false)
    private FRIValue receivingFRI;

    public long getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(long financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<ReverseInstruction> getFinancialInstructionDetails() {
        return this.financialInstructionDetails;
    }

    public void setFinancialInstructionDetails(List<ReverseInstruction> financialInstructionDetails) {
        this.financialInstructionDetails = financialInstructionDetails;
    }

    public Long getReverseFinancialTransactionId() {
        return this.reverseFinancialTransactionId;
    }

    public ReverseCountersValue getReverseCounters() {
        return this.reverseCounters;
    }

    public void setReverseCounters(ReverseCountersValue reverseCounters) {
        this.reverseCounters = reverseCounters;
    }

    public FRIValue getReceivingFRI() {
        return this.receivingFRI;
    }

    public void setReceivingFRI(FRIValue receivingFRI) {
        this.receivingFRI = receivingFRI;
    }
}

