/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_7.gettransactionhistory;

import com.ericsson.em.m3if.financial.v1_0.common.Direction;
import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.v1_0.common.CommunicationChannel;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionStatus;
import com.ericsson.em.m3if.v1_0.common.ProviderCategory;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v2_1.common.FinancialInstructionType;
import com.ericsson.em.validators.IsExternalTransactionIdString;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsMSISDN;
import com.ericsson.em.validators.IsPositiveLong;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_7", name="gettransactionhistoryrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_7", name="", propOrder={"fri", "numOfTransactions", "indexOffset", "financialTransactionId", "externalTransactionId", "transactionStatus", "transactionType", "startDateFrom", "startDateTo", "dateFrom", "dateTo", "direction", "otherFri", "communicationChannel", "providerCategory", "posMsisdn", "quoteId"})
public class GetTransactionHistoryRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MAXLIMIT = 50;
    @IsFinancialResourceIdentifier
    @XmlElement(name="fri")
    private String fri;
    @Min(value=1L)
    @NotNull
    @XmlElement(name="numoftransactions", defaultValue="50")
    private @Min(value=1L) @NotNull int numOfTransactions;
    @XmlElement(name="indexoffset", defaultValue="0")
    private int indexOffset = 0;
    @IsPositiveLong(allowZero=false)
    @XmlElement(name="financialtransactionid")
    private Long financialTransactionId;
    @IsExternalTransactionIdString
    @XmlElement(name="externaltransactionid")
    private String externalTransactionId;
    @XmlElement(name="transactionstatus")
    private FinancialTransactionStatus transactionStatus;
    @Valid
    @NoNullElements
    @XmlElement(name="transactiontype", type=FinancialInstructionType.class)
    private List<FinancialInstructionType> transactionType = new LinkedList<FinancialInstructionType>();
    @XmlElement(name="startdatefrom")
    private Date startDateFrom;
    @XmlElement(name="startdateto")
    private Date startDateTo;
    @XmlElement(name="datefrom")
    private Date dateFrom;
    @XmlElement(name="dateto")
    private Date dateTo;
    @XmlElement(name="direction")
    private Direction direction;
    @IsFinancialResourceIdentifier
    @XmlElement(name="otherfri")
    private String otherFri;
    @Valid
    @XmlElement(name="communicationchannel")
    private CommunicationChannel communicationChannel;
    @Valid
    @XmlElement(name="providercategory")
    private ProviderCategory providerCategory;
    @IsMSISDN
    @XmlElement(name="posmsisdn")
    private String posMsisdn;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;

    public GetTransactionHistoryRequest() {
        this.numOfTransactions = 50;
    }

    public GetTransactionHistoryRequest(String fri) {
        this.fri = fri;
        this.numOfTransactions = 50;
    }

    public GetTransactionHistoryRequest(String fri, int maxLimit) {
        this.fri = fri;
        this.numOfTransactions = maxLimit;
    }

    public GetTransactionHistoryRequest(String fri, DateTime dateFrom, DateTime dateTo, int maxLimit, int indexOffset) {
        this.fri = fri;
        this.dateFrom = DateHelper.toDate(dateFrom);
        this.dateTo = DateHelper.toDate(dateTo);
        this.numOfTransactions = maxLimit;
        this.indexOffset = indexOffset;
    }

    public String getFri() {
        return this.fri;
    }

    public void setFri(String fri) {
        this.fri = fri;
    }

    public DateTime getStartDateFrom() {
        return DateHelper.fromDate(this.startDateFrom);
    }

    public void setStartDateFrom(DateTime startDateFrom) {
        this.startDateFrom = DateHelper.toDate(startDateFrom);
    }

    public DateTime getStartDateTo() {
        return DateHelper.fromDate(this.startDateTo);
    }

    public void setStartDateTo(DateTime startDateTo) {
        this.startDateTo = DateHelper.toDate(startDateTo);
    }

    public DateTime getDateFrom() {
        return DateHelper.fromDate(this.dateFrom);
    }

    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = DateHelper.toDate(dateFrom);
    }

    public DateTime getDateTo() {
        return DateHelper.fromDate(this.dateTo);
    }

    public void setDateTo(DateTime dateTo) {
        this.dateTo = DateHelper.toDate(dateTo);
    }

    public int getIndexOffset() {
        return this.indexOffset;
    }

    public void setIndexOffset(int indexOffset) {
        this.indexOffset = indexOffset;
    }

    public void setNumOfTransactions(int numOfTransactions) {
        this.numOfTransactions = numOfTransactions;
    }

    @XmlTransient
    public int getNumOfTransactions() {
        return this.numOfTransactions;
    }

    public Long getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(Long financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public String getExternalTransactionId() {
        return this.externalTransactionId;
    }

    public void setExternalTransactionId(String externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }

    public FinancialTransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(FinancialTransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public List<FinancialInstructionType> getTransactionType() {
        return this.transactionType;
    }

    public void addTransactionType(FinancialInstructionType transactionType) {
        this.transactionType.add(transactionType);
    }

    public void setTransactionType(List<FinancialInstructionType> transactionTypes) {
        this.transactionType = transactionTypes;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public String getOtherFri() {
        return this.otherFri;
    }

    public void setOtherFri(String otherFri) {
        this.otherFri = otherFri;
    }

    public CommunicationChannel getCommunicationChannel() {
        return this.communicationChannel;
    }

    public void setCommunicationChannel(CommunicationChannel communicationChannel) {
        this.communicationChannel = communicationChannel;
    }

    public ProviderCategory getProviderCategory() {
        return this.providerCategory;
    }

    public void setProviderCategory(ProviderCategory providerCategory) {
        this.providerCategory = providerCategory;
    }

    public String getPosMsisdn() {
        return this.posMsisdn;
    }

    public void setPosMsisdn(String posMsisdn) {
        this.posMsisdn = posMsisdn;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }
}

