/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v2_0.gettransactionhistory;

import com.ericsson.em.m3if.financial.v1_0.common.Direction;
import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.v1_0.common.CommunicationChannel;
import com.ericsson.em.m3if.v1_0.common.ExternalTransactionIdValue;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionId;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionStatus;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.MsisdnValue;
import com.ericsson.em.m3if.v1_0.common.ProviderCategory;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v2_1.common.FinancialInstructionType;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v2_0", name="gettransactionhistoryrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v2_0", name="", propOrder={"fri", "numOfTransactions", "indexOffset", "financialTransactionId", "externalTransactionId", "transactionStatus", "transactionTypes", "startDateFrom", "startDateTo", "dateFrom", "dateTo", "direction", "otherFri", "communicationChannel", "providerCategory", "posMsisdn", "quoteId"})
public class GetTransactionHistoryRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MAXLIMIT = 50;
    @Valid
    @XmlElement(name="fri", type=FRIValue.class)
    private FRIValue fri;
    @Min(value=1L)
    @NotNull
    @XmlElement(name="numoftransactions", defaultValue="50")
    private @Min(value=1L) @NotNull int numOfTransactions;
    @Min(value=0L)
    @XmlElement(name="indexoffset", defaultValue="0")
    private @Min(value=0L) int indexOffset;
    @Valid
    @XmlElement(name="financialtransactionid", type=FinancialTransactionId.class)
    private FinancialTransactionId financialTransactionId;
    @Valid
    @XmlElement(name="externaltransactionid", type=ExternalTransactionIdValue.class)
    private ExternalTransactionIdValue externalTransactionId;
    @Valid
    @XmlElement(name="transactionstatus", type=FinancialTransactionStatus.class)
    private FinancialTransactionStatus transactionStatus;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="transactiontypes")
    @XmlElements(value={@XmlElement(name="transactiontype", type=FinancialInstructionType.class)})
    private List<FinancialInstructionType> transactionTypes = new LinkedList<FinancialInstructionType>();
    @Valid
    @XmlElement(name="startdatefrom", type=Iso8601DateTime.class)
    private Iso8601DateTime startDateFrom;
    @Valid
    @XmlElement(name="startdateto", type=Iso8601DateTime.class)
    private Iso8601DateTime startDateTo;
    @Valid
    @XmlElement(name="datefrom", type=Iso8601DateTime.class)
    private Iso8601DateTime dateFrom;
    @Valid
    @XmlElement(name="dateto", type=Iso8601DateTime.class)
    private Iso8601DateTime dateTo;
    @Valid
    @XmlElement(name="direction", type=Direction.class)
    private Direction direction;
    @Valid
    @XmlElement(name="otherfri", type=FRIValue.class)
    private FRIValue otherFri;
    @Valid
    @XmlElement(name="communicationchannel", type=CommunicationChannel.class)
    private CommunicationChannel communicationChannel;
    @Valid
    @XmlElement(name="providercategory", type=ProviderCategory.class)
    private ProviderCategory providerCategory;
    @Valid
    @XmlElement(name="posmsisdn", type=MsisdnValue.class)
    private MsisdnValue posMsisdn;
    @Valid
    @XmlElement(name="quoteid", type=QuoteId.class)
    private QuoteId quoteId;

    public GetTransactionHistoryRequest() {
        this.numOfTransactions = 50;
    }

    public GetTransactionHistoryRequest(FRIValue fri) {
        this.fri = fri;
        this.numOfTransactions = 50;
    }

    public GetTransactionHistoryRequest(FRIValue fri, int maxLimit) {
        this.fri = fri;
        this.numOfTransactions = maxLimit;
    }

    public GetTransactionHistoryRequest(FRIValue fri, Iso8601DateTime dateFrom, Iso8601DateTime dateTo, int maxLimit, int indexOffset) {
        this.fri = fri;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        this.numOfTransactions = maxLimit;
        this.indexOffset = indexOffset;
    }

    public FRIValue getFri() {
        return this.fri;
    }

    public void setFri(FRIValue fri) {
        this.fri = fri;
    }

    public Iso8601DateTime getStartDateFrom() {
        return this.startDateFrom;
    }

    public void setStartDateFrom(Iso8601DateTime startDateFrom) {
        this.startDateFrom = startDateFrom;
    }

    public Iso8601DateTime getStartDateTo() {
        return this.startDateTo;
    }

    public void setStartDateTo(Iso8601DateTime startDateTo) {
        this.startDateTo = startDateTo;
    }

    public Iso8601DateTime getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Iso8601DateTime dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Iso8601DateTime getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Iso8601DateTime dateTo) {
        this.dateTo = dateTo;
    }

    public int getIndexOffset() {
        return this.indexOffset;
    }

    public void setIndexOffset(int indexOffset) {
        this.indexOffset = indexOffset;
    }

    public void setNumOfTransactions(int numOfTransactions) {
        this.numOfTransactions = numOfTransactions;
    }

    @XmlTransient
    public int getNumOfTransactions() {
        return this.numOfTransactions;
    }

    public FinancialTransactionId getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(FinancialTransactionId financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public ExternalTransactionIdValue getExternalTransactionId() {
        return this.externalTransactionId;
    }

    public void setExternalTransactionId(ExternalTransactionIdValue externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }

    public FinancialTransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(FinancialTransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public List<FinancialInstructionType> getTransactionTypes() {
        return this.transactionTypes;
    }

    public void addTransactionType(FinancialInstructionType transactionType) {
        this.transactionTypes.add(transactionType);
    }

    public void setTransactionTypes(List<FinancialInstructionType> transactionTypes) {
        this.transactionTypes = transactionTypes;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public FRIValue getOtherFri() {
        return this.otherFri;
    }

    public void setOtherFri(FRIValue otherFri) {
        this.otherFri = otherFri;
    }

    public CommunicationChannel getCommunicationChannel() {
        return this.communicationChannel;
    }

    public void setCommunicationChannel(CommunicationChannel communicationChannel) {
        this.communicationChannel = communicationChannel;
    }

    public ProviderCategory getProviderCategory() {
        return this.providerCategory;
    }

    public void setProviderCategory(ProviderCategory providerCategory) {
        this.providerCategory = providerCategory;
    }

    public MsisdnValue getPosMsisdn() {
        return this.posMsisdn;
    }

    public void setPosMsisdn(MsisdnValue posMsisdn) {
        this.posMsisdn = posMsisdn;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }
}

