/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v2_1.common;

import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.Argument;
import com.ericsson.em.m3if.v1_0.common.ExternalTransactionIdValue;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionId;
import com.ericsson.em.m3if.v1_0.common.FirstnameValue;
import com.ericsson.em.m3if.v1_0.common.IdentityValue;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.MultiWordStringValue;
import com.ericsson.em.m3if.v1_0.common.ProviderCategory;
import com.ericsson.em.m3if.v1_0.common.ReasonValue;
import com.ericsson.em.m3if.v1_0.common.SurnameValue;
import com.ericsson.em.m3if.v1_0.common.UsernameValue;
import com.ericsson.em.m3if.v2_1.common.TransferType;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v2_1/common", name="rejectedtransactionentry", propOrder={"financialTransactionId", "transferType", "startDate", "initiatingUser", "realUser", "reviewingUser", "initiatingAccountHolder", "realAccountHolder", "providerCategory", "from", "fromFirstName", "fromLastName", "fromAccount", "fromAmount", "fromFee", "fromTax", "fromDiscount", "fromPromotion", "to", "toFirstName", "toLastName", "toAccount", "toAmount", "toFee", "toTax", "toPromotion", "cause", "reason", "externalTransactionId", "arguments"})
public class RejectedTransactionEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    @XmlElement(name="financialtransactionid")
    private FinancialTransactionId financialTransactionId = null;
    @Valid
    @XmlElement(name="transfertype")
    private TransferType transferType;
    @Valid
    @XmlElement(name="startdate")
    private Iso8601DateTime startDate;
    @Valid
    @XmlElement(name="initiatinguser")
    private UsernameValue initiatingUser;
    @Valid
    @XmlElement(name="realuser")
    private UsernameValue realUser;
    @Valid
    @XmlElement(name="reviewinguser")
    private UsernameValue reviewingUser;
    @Valid
    @XmlElement(name="initiatingaccountholder")
    private IdentityValue initiatingAccountHolder;
    @Valid
    @XmlElement(name="realaccountholder")
    private IdentityValue realAccountHolder;
    @Valid
    @XmlElement(name="providercategory")
    private ProviderCategory providerCategory;
    @Valid
    @XmlElement(name="from")
    private FRIValue from;
    @Valid
    @XmlElement(name="fromfirstname")
    private FirstnameValue fromFirstName;
    @Valid
    @XmlElement(name="fromlastname")
    private SurnameValue fromLastName;
    @Valid
    @XmlElement(name="fromaccount")
    private FRIValue fromAccount;
    @Valid
    @XmlElement(name="fromamount")
    @IsPositiveAmount
    private MoneyDetails fromAmount;
    @Valid
    @XmlElement(name="fromfee")
    @IsPositiveAmount
    private MoneyDetails fromFee;
    @Valid
    @XmlElement(name="fromtax")
    @IsPositiveAmount
    private MoneyDetails fromTax;
    @Valid
    @XmlElement(name="fromdiscount")
    @IsPositiveAmount
    private MoneyDetails fromDiscount;
    @Valid
    @XmlElement(name="frompromotion")
    @IsPositiveAmount
    private MoneyDetails fromPromotion;
    @Valid
    @XmlElement(name="to")
    private FRIValue to;
    @Valid
    @XmlElement(name="tofirstname")
    private FirstnameValue toFirstName;
    @Valid
    @XmlElement(name="tolastname")
    private SurnameValue toLastName;
    @Valid
    @XmlElement(name="toaccount")
    private FRIValue toAccount;
    @Valid
    @XmlElement(name="toamount")
    @IsPositiveAmount
    private MoneyDetails toAmount;
    @Valid
    @XmlElement(name="tofee")
    @IsPositiveAmount
    private MoneyDetails toFee;
    @Valid
    @XmlElement(name="totax")
    @IsPositiveAmount
    private MoneyDetails toTax;
    @Valid
    @XmlElement(name="topromotion")
    @IsPositiveAmount
    private MoneyDetails toPromotion;
    @Valid
    @XmlElement(name="cause")
    private MultiWordStringValue cause;
    @Valid
    @XmlElement(name="reason")
    private ReasonValue reason;
    @Valid
    @XmlElement(name="externaltransactionid")
    private ExternalTransactionIdValue externalTransactionId;
    @Valid
    @NotNull
    @NoNullElements
    @XmlElementWrapper(name="arguments", required=true)
    @XmlElements(value={@XmlElement(name="argument", type=Argument.class)})
    private final List<Argument> arguments = new LinkedList<Argument>();

    public void addArgument(Argument argument) {
        if (argument != null) {
            this.arguments.add(argument);
        }
    }

    public void addArgument(String name, BigDecimal value) {
        if (name != null && value != null) {
            this.arguments.add(new Argument(name, value.toPlainString()));
        }
    }

    public void addArgument(String name, int value) {
        if (name != null) {
            this.arguments.add(new Argument(name, String.valueOf(value)));
        }
    }

    public void addArgument(String name, MoneyDetails value) {
        if (name != null && value != null) {
            this.arguments.add(new Argument(name, value));
        }
    }

    public void addArgument(String name, String value) {
        if (name != null && value != null) {
            this.arguments.add(new Argument(name, value));
        }
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<Argument> arguments) {
        this.arguments.clear();
        this.arguments.addAll(arguments);
    }

    public MultiWordStringValue getCause() {
        return this.cause;
    }

    public FinancialTransactionId getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public FRIValue getFrom() {
        return this.from;
    }

    public FRIValue getFromAccount() {
        return this.fromAccount;
    }

    public MoneyDetails getFromAmount() {
        return this.fromAmount;
    }

    public MoneyDetails getFromDiscount() {
        return this.fromDiscount;
    }

    public MoneyDetails getFromFee() {
        return this.fromFee;
    }

    public MoneyDetails getFromTax() {
        return this.fromTax;
    }

    public MoneyDetails getFromPromotion() {
        return this.fromPromotion;
    }

    public IdentityValue getInitiatingAccountHolder() {
        return this.initiatingAccountHolder;
    }

    public UsernameValue getInitiatingUser() {
        return this.initiatingUser;
    }

    public IdentityValue getRealAccountHolder() {
        return this.realAccountHolder;
    }

    public UsernameValue getRealUser() {
        return this.realUser;
    }

    public UsernameValue getReviewingUser() {
        return this.reviewingUser;
    }

    public ReasonValue getReason() {
        return this.reason;
    }

    public Iso8601DateTime getStartDate() {
        return this.startDate;
    }

    public FRIValue getTo() {
        return this.to;
    }

    public FRIValue getToAccount() {
        return this.toAccount;
    }

    public MoneyDetails getToAmount() {
        return this.toAmount;
    }

    public MoneyDetails getToFee() {
        return this.toFee;
    }

    public MoneyDetails getToTax() {
        return this.toTax;
    }

    public MoneyDetails getToPromotion() {
        return this.toPromotion;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public void setCause(MultiWordStringValue cause) {
        this.cause = cause;
    }

    public void setFinancialTransactionId(FinancialTransactionId financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public void setFrom(FRIValue source) {
        this.from = source;
    }

    public void setFromAccount(FRIValue fromAccount) {
        this.fromAccount = fromAccount;
    }

    public void setFromAmount(MoneyDetails fromAmount) {
        this.fromAmount = fromAmount;
    }

    public void setFromDiscount(MoneyDetails fromDiscount) {
        this.fromDiscount = fromDiscount;
    }

    public void setFromFee(MoneyDetails fromFee) {
        this.fromFee = fromFee;
    }

    public void setFromTax(MoneyDetails fromTax) {
        this.fromTax = fromTax;
    }

    public void setFromPromotion(MoneyDetails fromPromotion) {
        this.fromPromotion = fromPromotion;
    }

    public void setInitiatingAccountHolder(IdentityValue initiatingAccountHolder) {
        this.initiatingAccountHolder = initiatingAccountHolder;
    }

    public void setInitiatingUser(UsernameValue initiatingUser) {
        this.initiatingUser = initiatingUser;
    }

    public void setRealAccountHolder(IdentityValue realAccountHolder) {
        this.realAccountHolder = realAccountHolder;
    }

    public void setRealUser(UsernameValue real) {
        this.realUser = real;
    }

    public void setReviewingUser(UsernameValue reviewingUser) {
        this.reviewingUser = reviewingUser;
    }

    public void setReason(ReasonValue reason) {
        this.reason = reason;
    }

    public void setStartDate(Iso8601DateTime startDate) {
        this.startDate = startDate;
    }

    public void setTo(FRIValue target) {
        this.to = target;
    }

    public void setToAccount(FRIValue toAccount) {
        this.toAccount = toAccount;
    }

    public void setToAmount(MoneyDetails toAmount) {
        this.toAmount = toAmount;
    }

    public void setToFee(MoneyDetails toFee) {
        this.toFee = toFee;
    }

    public void setToTax(MoneyDetails toTax) {
        this.toTax = toTax;
    }

    public void setToPromotion(MoneyDetails toPromotion) {
        this.toPromotion = toPromotion;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public ProviderCategory getProviderCategory() {
        return this.providerCategory;
    }

    public void setProviderCategory(ProviderCategory providerCategory) {
        this.providerCategory = providerCategory;
    }

    public FirstnameValue getFromFirstName() {
        return this.fromFirstName;
    }

    public void setFromFirstName(FirstnameValue fromFirstName) {
        this.fromFirstName = fromFirstName;
    }

    public SurnameValue getFromLastName() {
        return this.fromLastName;
    }

    public void setFromLastName(SurnameValue fromLastName) {
        this.fromLastName = fromLastName;
    }

    public FirstnameValue getToFirstName() {
        return this.toFirstName;
    }

    public void setToFirstName(FirstnameValue toFirstName) {
        this.toFirstName = toFirstName;
    }

    public SurnameValue getToLastName() {
        return this.toLastName;
    }

    public void setToLastName(SurnameValue toLastName) {
        this.toLastName = toLastName;
    }

    public ExternalTransactionIdValue getExternalTransactionId() {
        return this.externalTransactionId;
    }

    public void setExternalTransactionId(ExternalTransactionIdValue externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }
}

