/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v2_5.common;

import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.Argument;
import com.ericsson.em.m3if.v1_0.common.ExternalTransactionIdValue;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionId;
import com.ericsson.em.m3if.v1_0.common.FirstnameValue;
import com.ericsson.em.m3if.v1_0.common.FxRate;
import com.ericsson.em.m3if.v1_0.common.IdentityValue;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.MultiWordStringValue;
import com.ericsson.em.m3if.v1_0.common.ProviderCategory;
import com.ericsson.em.m3if.v1_0.common.ReasonValue;
import com.ericsson.em.m3if.v1_0.common.ServiceProviderId;
import com.ericsson.em.m3if.v1_0.common.SurnameValue;
import com.ericsson.em.m3if.v2_1.common.TransferType;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v2_5/common", name="rejectedtransactionentry", propOrder={"financialTransactionId", "transferType", "startDate", "initiatingUser", "realUser", "reviewingUser", "initiatingAccountHolder", "realAccountHolder", "providerCategory", "from", "fromFirstName", "fromLastName", "fromHandlerFirstName", "fromHandlerLastName", "fromAccount", "fromAmount", "fromFee", "fromTaxes", "fromDiscount", "fromPromotion", "to", "toFirstName", "toLastName", "toHandlerFirstName", "toHandlerLastName", "toAccount", "toAmount", "toFee", "toTaxes", "toPromotion", "cause", "reason", "externalTransactionId", "originalAmount", "externalAmount", "externalFxRate", "arguments", "externalServiceProvider"})
@Deprecated
public class RejectedTransactionEntry
implements Serializable {
    private static final long serialVersionUID = 6309306158067080848L;
    @Valid
    @XmlElement(name="financialtransactionid")
    private FinancialTransactionId financialTransactionId;
    @Valid
    @XmlElement(name="transfertype")
    private TransferType transferType;
    @Valid
    @XmlElement(name="startdate")
    private Iso8601DateTime startDate;
    @Valid
    @XmlElement(name="initiatinguser")
    private IdentityValue initiatingUser;
    @Valid
    @XmlElement(name="realuser")
    private IdentityValue realUser;
    @Valid
    @XmlElement(name="reviewinguser")
    private IdentityValue reviewingUser;
    @Valid
    @XmlElement(name="initiatingaccountholder")
    private IdentityValue initiatingAccountHolder;
    @Valid
    @XmlElement(name="realaccountholder")
    private IdentityValue realAccountHolder;
    @Valid
    @XmlElement(name="providercategory")
    private ProviderCategory providerCategory;
    @Valid
    @XmlElement(name="from")
    private FRIValue from;
    @Valid
    @XmlElement(name="fromfirstname")
    private FirstnameValue fromFirstName;
    @Valid
    @XmlElement(name="fromlastname")
    private SurnameValue fromLastName;
    @Valid
    @XmlElement(name="fromhandlerfirstname")
    private FirstnameValue fromHandlerFirstName;
    @Valid
    @XmlElement(name="fromhandlerlastname")
    private SurnameValue fromHandlerLastName;
    @Valid
    @XmlElement(name="fromaccount")
    private FRIValue fromAccount;
    @Valid
    @XmlElement(name="fromamount")
    @IsPositiveAmount
    private MoneyDetails fromAmount;
    @Valid
    @XmlElement(name="fromfee")
    @IsPositiveAmount
    private MoneyDetails fromFee;
    @Valid
    @XmlElement(name="fromtaxes")
    @IsPositiveAmount
    private MoneyDetails fromTaxes;
    @Valid
    @XmlElement(name="fromdiscount")
    @IsPositiveAmount
    private MoneyDetails fromDiscount;
    @Valid
    @XmlElement(name="frompromotion")
    @IsPositiveAmount
    private MoneyDetails fromPromotion;
    @Valid
    @XmlElement(name="to")
    private FRIValue to;
    @Valid
    @XmlElement(name="tofirstname")
    private FirstnameValue toFirstName;
    @Valid
    @XmlElement(name="tolastname")
    private SurnameValue toLastName;
    @Valid
    @XmlElement(name="tohandlerfirstname")
    private FirstnameValue toHandlerFirstName;
    @Valid
    @XmlElement(name="tohandlerlastname")
    private SurnameValue toHandlerLastName;
    @Valid
    @XmlElement(name="toaccount")
    private FRIValue toAccount;
    @Valid
    @XmlElement(name="toamount")
    @IsPositiveAmount
    private MoneyDetails toAmount;
    @Valid
    @XmlElement(name="tofee")
    @IsPositiveAmount
    private MoneyDetails toFee;
    @Valid
    @XmlElement(name="totaxes")
    @IsPositiveAmount
    private MoneyDetails toTaxes;
    @Valid
    @XmlElement(name="topromotion")
    @IsPositiveAmount
    private MoneyDetails toPromotion;
    @Valid
    @XmlElement(name="cause")
    private MultiWordStringValue cause;
    @Valid
    @XmlElement(name="reason")
    private ReasonValue reason;
    @Valid
    @XmlElement(name="externaltransactionid")
    private ExternalTransactionIdValue externalTransactionId;
    @Valid
    @XmlElement(name="originalamount")
    @IsPositiveAmount
    private MoneyDetails originalAmount;
    @Valid
    @XmlElement(name="externalamount")
    @IsPositiveAmount
    private MoneyDetails externalAmount;
    @Valid
    @XmlElement(name="externalfxrate")
    private FxRate externalFxRate;
    @Valid
    @NotNull
    @NoNullElements
    @XmlElementWrapper(name="arguments", required=true)
    @XmlElements(value={@XmlElement(name="argument", type=Argument.class)})
    private final List<Argument> arguments = new LinkedList<Argument>();
    @Valid
    @XmlElement(name="externalserviceprovider")
    private ServiceProviderId externalServiceProvider;

    public FinancialTransactionId getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(FinancialTransactionId financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public Iso8601DateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Iso8601DateTime startDate) {
        this.startDate = startDate;
    }

    public IdentityValue getInitiatingUser() {
        return this.initiatingUser;
    }

    public void setInitiatingUser(IdentityValue initiatingUser) {
        this.initiatingUser = initiatingUser;
    }

    public IdentityValue getRealUser() {
        return this.realUser;
    }

    public void setRealUser(IdentityValue realUser) {
        this.realUser = realUser;
    }

    public IdentityValue getReviewingUser() {
        return this.reviewingUser;
    }

    public void setReviewingUser(IdentityValue reviewingUser) {
        this.reviewingUser = reviewingUser;
    }

    public IdentityValue getInitiatingAccountHolder() {
        return this.initiatingAccountHolder;
    }

    public void setInitiatingAccountHolder(IdentityValue initiatingAccountHolder) {
        this.initiatingAccountHolder = initiatingAccountHolder;
    }

    public IdentityValue getRealAccountHolder() {
        return this.realAccountHolder;
    }

    public void setRealAccountHolder(IdentityValue realAccountHolder) {
        this.realAccountHolder = realAccountHolder;
    }

    public ProviderCategory getProviderCategory() {
        return this.providerCategory;
    }

    public void setProviderCategory(ProviderCategory providerCategory) {
        this.providerCategory = providerCategory;
    }

    public FRIValue getFrom() {
        return this.from;
    }

    public void setFrom(FRIValue from) {
        this.from = from;
    }

    public FirstnameValue getFromFirstName() {
        return this.fromFirstName;
    }

    public void setFromFirstName(FirstnameValue fromFirstName) {
        this.fromFirstName = fromFirstName;
    }

    public SurnameValue getFromLastName() {
        return this.fromLastName;
    }

    public void setFromLastName(SurnameValue fromLastName) {
        this.fromLastName = fromLastName;
    }

    public FirstnameValue getFromHandlerFirstName() {
        return this.fromHandlerFirstName;
    }

    public void setFromHandlerFirstName(FirstnameValue fromHandlerFirstName) {
        this.fromHandlerFirstName = fromHandlerFirstName;
    }

    public SurnameValue getFromHandlerLastName() {
        return this.fromHandlerLastName;
    }

    public void setFromHandlerLastName(SurnameValue fromHandlerLastName) {
        this.fromHandlerLastName = fromHandlerLastName;
    }

    public FRIValue getFromAccount() {
        return this.fromAccount;
    }

    public void setFromAccount(FRIValue fromAccount) {
        this.fromAccount = fromAccount;
    }

    public MoneyDetails getFromAmount() {
        return this.fromAmount;
    }

    public void setFromAmount(MoneyDetails fromAmount) {
        this.fromAmount = fromAmount;
    }

    public MoneyDetails getFromFee() {
        return this.fromFee;
    }

    public void setFromFee(MoneyDetails fromFee) {
        this.fromFee = fromFee;
    }

    public MoneyDetails getFromTaxes() {
        return this.fromTaxes;
    }

    public void setFromTaxes(MoneyDetails fromTaxes) {
        this.fromTaxes = fromTaxes;
    }

    public MoneyDetails getFromDiscount() {
        return this.fromDiscount;
    }

    public void setFromDiscount(MoneyDetails fromDiscount) {
        this.fromDiscount = fromDiscount;
    }

    public MoneyDetails getFromPromotion() {
        return this.fromPromotion;
    }

    public void setFromPromotion(MoneyDetails fromPromotion) {
        this.fromPromotion = fromPromotion;
    }

    public FRIValue getTo() {
        return this.to;
    }

    public void setTo(FRIValue to) {
        this.to = to;
    }

    public FirstnameValue getToFirstName() {
        return this.toFirstName;
    }

    public void setToFirstName(FirstnameValue toFirstName) {
        this.toFirstName = toFirstName;
    }

    public SurnameValue getToLastName() {
        return this.toLastName;
    }

    public void setToLastName(SurnameValue toLastName) {
        this.toLastName = toLastName;
    }

    public FirstnameValue getToHandlerFirstName() {
        return this.toHandlerFirstName;
    }

    public void setToHandlerFirstName(FirstnameValue toHandlerFirstName) {
        this.toHandlerFirstName = toHandlerFirstName;
    }

    public SurnameValue getToHandlerLastName() {
        return this.toHandlerLastName;
    }

    public void setToHandlerLastName(SurnameValue toHandlerLastName) {
        this.toHandlerLastName = toHandlerLastName;
    }

    public FRIValue getToAccount() {
        return this.toAccount;
    }

    public void setToAccount(FRIValue toAccount) {
        this.toAccount = toAccount;
    }

    public MoneyDetails getToAmount() {
        return this.toAmount;
    }

    public void setToAmount(MoneyDetails toAmount) {
        this.toAmount = toAmount;
    }

    public MoneyDetails getToFee() {
        return this.toFee;
    }

    public void setToFee(MoneyDetails toFee) {
        this.toFee = toFee;
    }

    public MoneyDetails getToTaxes() {
        return this.toTaxes;
    }

    public void setToTaxes(MoneyDetails toTaxes) {
        this.toTaxes = toTaxes;
    }

    public MoneyDetails getToPromotion() {
        return this.toPromotion;
    }

    public void setToPromotion(MoneyDetails toPromotion) {
        this.toPromotion = toPromotion;
    }

    public MultiWordStringValue getCause() {
        return this.cause;
    }

    public void setCause(MultiWordStringValue cause) {
        this.cause = cause;
    }

    public ReasonValue getReason() {
        return this.reason;
    }

    public void setReason(ReasonValue reason) {
        this.reason = reason;
    }

    public ExternalTransactionIdValue getExternalTransactionId() {
        return this.externalTransactionId;
    }

    public void setExternalTransactionId(ExternalTransactionIdValue externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }

    public MoneyDetails getOriginalAmount() {
        return this.originalAmount;
    }

    public void setOriginalAmount(MoneyDetails originalAmount) {
        this.originalAmount = originalAmount;
    }

    public MoneyDetails getExternalAmount() {
        return this.externalAmount;
    }

    public void setExternalAmount(MoneyDetails externalAmount) {
        this.externalAmount = externalAmount;
    }

    public FxRate getExternalFxRate() {
        return this.externalFxRate;
    }

    public void setExternalFxRate(FxRate externalFxRate) {
        this.externalFxRate = externalFxRate;
    }

    public List<Argument> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public void addArgument(Argument argument) {
        if (argument != null) {
            this.arguments.add(argument);
        }
    }

    public void addArgument(String name, BigDecimal value) {
        if (name != null && value != null) {
            this.arguments.add(new Argument(name, value.toPlainString()));
        }
    }

    public void addArgument(String name, int value) {
        if (name != null) {
            this.arguments.add(new Argument(name, String.valueOf(value)));
        }
    }

    public void addArgument(String name, MoneyDetails value) {
        if (name != null && value != null) {
            this.arguments.add(new Argument(name, value));
        }
    }

    public void addArgument(String name, String value) {
        if (name != null && value != null) {
            this.arguments.add(new Argument(name, value));
        }
    }

    public void setArguments(List<Argument> arguments) {
        this.arguments.clear();
        this.arguments.addAll(arguments);
    }

    public void setExternalServiceProvider(ServiceProviderId externalServiceProvider) {
        this.externalServiceProvider = externalServiceProvider;
    }

    public ServiceProviderId getExternalServiceProvider() {
        return this.externalServiceProvider;
    }
}

