/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v3_0.merchantpayment;

import com.ericsson.em.m3if.financial.v1_0.quotation.Assistable;
import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.Coupon;
import com.ericsson.em.m3if.v1_0.common.ExtensionType;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v1_0.common.ReceiverMessageValue;
import com.ericsson.em.m3if.v1_0.common.RequestReferenceId;
import com.ericsson.em.m3if.v1_0.common.SenderNoteValue;
import com.ericsson.em.m3if.v1_3.common.ScheduledTransactionDate;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v3_0", name="merchantpaymentrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v3_0", name="", propOrder={"sendingFRI", "receivingFRI", "amount", "senderNote", "receiverMessage", "quoteId", "coupon", "requestReferenceId", "extension", "scheduled", "includeOffNet"})
@Deprecated
public class MerchantPaymentRequest
implements Serializable,
QuoteRequest,
Assistable {
    private static final long serialVersionUID = 1L;
    @Valid
    @XmlElement(name="sendingfri", type=FRIValue.class, required=false)
    private FRIValue sendingFRI;
    @Valid
    @NotNull
    @XmlElement(name="receivingfri", type=FRIValue.class, required=true)
    private FRIValue receivingFRI;
    @Valid
    @NotNull
    @IsPositiveAmount
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    private MoneyDetails amount;
    @Valid
    @XmlElement(name="sendernote", type=SenderNoteValue.class, required=false)
    private SenderNoteValue senderNote;
    @Valid
    @XmlElement(name="receivermessage", type=ReceiverMessageValue.class, required=false)
    private ReceiverMessageValue receiverMessage;
    @Valid
    @XmlElement(name="quoteid", type=QuoteId.class, required=false)
    private QuoteId quoteId;
    @Valid
    @XmlElement(name="coupon", type=Coupon.class, required=false)
    private Coupon coupon;
    @Valid
    @XmlElement(name="requestreferenceid", type=RequestReferenceId.class, required=false)
    private RequestReferenceId requestReferenceId;
    @Valid
    @XmlElement(name="extension", type=ExtensionType.class, required=false)
    private ExtensionType extension;
    @Valid
    @XmlElement(name="scheduled", type=ScheduledTransactionDate.class, required=false)
    private ScheduledTransactionDate scheduled;
    @XmlElement(name="includeoffnet", defaultValue="false")
    private Boolean includeOffNet = false;

    public MerchantPaymentRequest() {
    }

    public MerchantPaymentRequest(FRIValue from, FRIValue to, MoneyDetails amount) {
        this.sendingFRI = from;
        this.receivingFRI = to;
        this.amount = amount;
    }

    public MerchantPaymentRequest(FRIValue from, FRIValue to, MoneyDetails amount, String senderNote, String receiverMessage, ExtensionType extension) {
        this(from, to, amount);
        this.senderNote = SenderNoteValue.fromString(senderNote);
        this.receiverMessage = ReceiverMessageValue.fromString(receiverMessage);
        this.extension = extension;
    }

    public FRIValue getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(FRIValue sendingFRI) {
        this.sendingFRI = sendingFRI;
    }

    public FRIValue getReceivingFRI() {
        return this.receivingFRI;
    }

    public void setReceivingFRI(FRIValue receivingFRI) {
        this.receivingFRI = receivingFRI;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public SenderNoteValue getSenderNote() {
        return this.senderNote;
    }

    public void setSenderNote(SenderNoteValue senderNote) {
        this.senderNote = senderNote;
    }

    public ReceiverMessageValue getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(ReceiverMessageValue receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public Coupon getCoupon() {
        return this.coupon;
    }

    public void setCoupon(Coupon coupon) {
        this.coupon = coupon;
    }

    public RequestReferenceId getRequestReferenceId() {
        return this.requestReferenceId;
    }

    public void setRequestReferenceId(RequestReferenceId requestReferenceId) {
        this.requestReferenceId = requestReferenceId;
    }

    public ExtensionType getExtension() {
        return this.extension;
    }

    public void setExtension(ExtensionType extension) {
        this.extension = extension;
    }

    public ScheduledTransactionDate getScheduled() {
        return this.scheduled;
    }

    public void setScheduled(ScheduledTransactionDate scheduled) {
        this.scheduled = scheduled;
    }

    public Boolean getIncludeOffNet() {
        return this.includeOffNet;
    }

    public void setIncludeOffNet(Boolean includeOffNet) {
        this.includeOffNet = includeOffNet;
    }
}

