/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.internal.settlement.configuration;

import com.ericsson.em.validators.IsASCIISimpleString;
import com.ericsson.em.validators.IsURL;
import com.ericsson.em.validators.IsUsername;
import com.ericsson.em.validators.Length;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/internal/settlement", name="", propOrder={"url", "secureSocketProtocol", "clientAlias", "passwordKey", "username", "maxPoolSize", "idleTime", "connectionTimeout"})
public class HttpClientConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Length(min=8, max=256)
    @IsURL
    @XmlElement(name="url")
    private String url;
    @IsASCIISimpleString
    @XmlElement(name="securesocketprotocol", defaultValue="TLS")
    private String secureSocketProtocol = "TLS";
    @IsASCIISimpleString
    @XmlElement(name="clientalias")
    private String clientAlias;
    @Length(min=0, max=64)
    @IsASCIISimpleString
    @XmlElement(name="passwordkey")
    private String passwordKey;
    @Length(min=0, max=64)
    @IsUsername
    @XmlElement(name="username")
    private String username;
    @NotNull
    @Min(value=0L)
    @XmlElement(name="maxpoolsize", defaultValue="20")
    private @NotNull @Min(value=0L) Integer maxPoolSize = 20;
    @NotNull
    @Min(value=0L)
    @XmlElement(name="idletime", defaultValue="30")
    private @NotNull @Min(value=0L) Integer idleTime = 30;
    @NotNull
    @Min(value=0L)
    @XmlElement(name="connectiontimeout", defaultValue="10")
    private @NotNull @Min(value=0L) Integer connectionTimeout = 10;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSecureSocketProtocol() {
        return this.secureSocketProtocol;
    }

    public void setSecureSocketProtocol(String secureSocketProtocol) {
        this.secureSocketProtocol = secureSocketProtocol;
    }

    public String getClientAlias() {
        return this.clientAlias;
    }

    public void setClientAlias(String clientAlias) {
        this.clientAlias = clientAlias;
    }

    public String getPasswordKey() {
        return this.passwordKey;
    }

    public void setPasswordKey(String passwordKey) {
        this.passwordKey = passwordKey;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public Integer getIdleTime() {
        return this.idleTime;
    }

    public void setIdleTime(Integer idleTime) {
        this.idleTime = idleTime;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }
}

