/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.internal.settlement.configuration;

import com.ericsson.em.m3if.internal.settlement.configuration.DuplicateCheckField;
import com.ericsson.em.m3if.internal.settlement.configuration.HttpClientConfiguration;
import com.ericsson.em.m3if.internal.settlement.configuration.OnlineSettlementMode;
import com.ericsson.em.m3if.internal.settlement.configuration.ThresholdViolationAction;
import com.ericsson.em.m3if.v1_0.common.CustodyAccountId;
import com.ericsson.em.validators.IsCallerIdentifier;
import com.ericsson.em.validators.IsDelimiterChar;
import com.ericsson.em.validators.IsJavaClass;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/internal/settlement", name="", propOrder={"callerIdentifier", "parserClass", "bankInstructionFormatterClass", "delimiter", "duplicateCheckFields", "onlineSettlementMode", "thresholdViolationAction", "httpClientConfiguration", "signCustodyAccountIds", "digestCustodyAccountIds"})
public class SettlementConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Length(min=1, max=64)
    @IsCallerIdentifier
    @XmlElement(name="calleridentifier")
    private String callerIdentifier;
    @Length(min=1, max=1024)
    @IsJavaClass
    @XmlElement(name="parserclass")
    private String parserClass;
    @Length(min=1, max=1024)
    @IsJavaClass
    @XmlElement(name="bankinstructionformatterclass")
    private String bankInstructionFormatterClass;
    @IsDelimiterChar
    @XmlElement(name="delimiter")
    private String delimiter;
    @Valid
    @NoNullElements
    @XmlElement(name="duplicatecheckfields", type=DuplicateCheckField.class)
    private List<DuplicateCheckField> duplicateCheckFields;
    @XmlElement(name="onlinesettlementmode")
    private OnlineSettlementMode onlineSettlementMode;
    @XmlElement(name="thresholdviolationaction")
    private ThresholdViolationAction thresholdViolationAction;
    @Valid
    @XmlElement(name="httpclientconfiguration")
    private HttpClientConfiguration httpClientConfiguration;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="signcustodyaccountids")
    @XmlElements(value={@XmlElement(name="id", type=CustodyAccountId.class)})
    private List<CustodyAccountId> signCustodyAccountIds = new LinkedList<CustodyAccountId>();
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="digestcustodyaccountids")
    @XmlElements(value={@XmlElement(name="id", type=CustodyAccountId.class)})
    private List<CustodyAccountId> digestCustodyAccountIds = new LinkedList<CustodyAccountId>();

    public String getCallerIdentifier() {
        return this.callerIdentifier;
    }

    public void setCallerIdentifier(String callerIdentifier) {
        this.callerIdentifier = callerIdentifier;
    }

    public String getParserClass() {
        return this.parserClass;
    }

    public void setParserClass(String parserClass) {
        this.parserClass = parserClass;
    }

    public String getBankInstructionFormatterClass() {
        return this.bankInstructionFormatterClass;
    }

    public void setBankInstructionFormatterClass(String bankInstructionFormatterClass) {
        this.bankInstructionFormatterClass = bankInstructionFormatterClass;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public List<DuplicateCheckField> getDuplicateCheckFields() {
        return this.duplicateCheckFields;
    }

    public void setDuplicateCheckFields(List<DuplicateCheckField> duplicateCheckFields) {
        this.duplicateCheckFields = duplicateCheckFields;
    }

    public void setOnlineSettlementMode(OnlineSettlementMode onlineSettlementEnabled) {
        this.onlineSettlementMode = onlineSettlementEnabled;
    }

    public OnlineSettlementMode getOnlineSettlementMode() {
        return this.onlineSettlementMode;
    }

    public ThresholdViolationAction getThresholdViolationAction() {
        return this.thresholdViolationAction;
    }

    public void setThresholdViolationAction(ThresholdViolationAction thresholdViolationAction) {
        this.thresholdViolationAction = thresholdViolationAction;
    }

    public HttpClientConfiguration getHttpClientConfiguration() {
        return this.httpClientConfiguration;
    }

    public void setHttpClientConfiguration(HttpClientConfiguration httpClientConfiguration) {
        this.httpClientConfiguration = httpClientConfiguration;
    }

    public List<CustodyAccountId> getSignCustodyAccountIds() {
        return this.signCustodyAccountIds;
    }

    public void setSignCustodyAccountIds(List<CustodyAccountId> signCustodyAccountIds) {
        this.signCustodyAccountIds = signCustodyAccountIds;
    }

    public List<CustodyAccountId> getDigestCustodyAccountIds() {
        return this.digestCustodyAccountIds;
    }

    public void setDigestCustodyAccountIds(List<CustodyAccountId> digestCustodyAccountIds) {
        this.digestCustodyAccountIds = digestCustodyAccountIds;
    }
}

