/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.overdraft.v1_0.common;

import com.ericsson.em.m3if.v1_0.common.CurrencyCode;
import com.ericsson.em.validators.IsAmount;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Currency;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/overdraft/v1_0/common", name="accessfee", propOrder={"currency", "value", "percentage"})
public class AccessFee
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    @NotNull
    @XmlElement(name="currency", type=CurrencyCode.class, required=true)
    private CurrencyCode currency;
    @XmlElement(name="value", type=BigDecimal.class)
    @IsAmount(allowZero=true)
    private BigDecimal value;
    @Valid
    @Min(value=0L)
    @Max(value=100L)
    @XmlElement(name="percentage", type=BigDecimal.class)
    private @Valid @Min(value=0L) @Max(value=100L) BigDecimal percentage;

    public CurrencyCode getCurrency() {
        return this.currency;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public BigDecimal getPercentage() {
        return this.percentage;
    }

    public static AccessFee fromDetails(Currency currency, BigDecimal percentage, BigDecimal value) {
        AccessFee accessFee = new AccessFee();
        accessFee.currency = CurrencyCode.from(currency);
        accessFee.value = value;
        accessFee.percentage = percentage;
        return accessFee;
    }

    public String toString() {
        return "AccessFee{currency=" + this.currency.getCode() + ", value=" + String.valueOf(this.value == null ? BigDecimal.ZERO : this.value) + ", percentage=" + String.valueOf(this.percentage == null ? BigDecimal.ZERO : this.percentage) + "}";
    }
}

