/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.overdraft.v1_0.common;

import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionId;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v2_1.common.TransferType;
import com.ericsson.em.validation.Validation;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/overdraft/v1_0/common", name="overdrafttransactiondetails", propOrder={"financialTransactionId", "amount", "commitDate", "fromAccount", "toAccount", "transferType", "accessFee", "accessFeeBalance", "interestBalance", "usedOverdraftBalance", "remainingOverdraftBalance"})
public class OverdraftTransactionDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    @NotNull
    @XmlElement(name="financialtransactionid", type=FinancialTransactionId.class, required=true)
    private FinancialTransactionId financialTransactionId;
    @Valid
    @XmlElement(name="amount", type=MoneyDetails.class)
    private MoneyDetails amount;
    @Valid
    @NotNull
    @XmlElement(name="commitdate", type=Iso8601DateTime.class, required=true)
    private Iso8601DateTime commitDate;
    @Valid
    @XmlElement(name="fromaccount", type=FRIValue.class)
    private FRIValue fromAccount;
    @Valid
    @XmlElement(name="toaccount", type=FRIValue.class)
    private FRIValue toAccount;
    @Valid
    @XmlElement(name="transfertype", type=TransferType.class)
    private TransferType transferType;
    @Valid
    @XmlElement(name="accessfee", type=MoneyDetails.class)
    private MoneyDetails accessFee;
    @Valid
    @XmlElement(name="accessfeebalance", type=MoneyDetails.class)
    private MoneyDetails accessFeeBalance;
    @Valid
    @XmlElement(name="interestbalance", type=MoneyDetails.class)
    private MoneyDetails interestBalance;
    @Valid
    @NotNull
    @XmlElement(name="usedoverdraftbalance", type=MoneyDetails.class, required=true)
    private MoneyDetails usedOverdraftBalance;
    @Valid
    @XmlElement(name="remainingoverdraftbalance", type=MoneyDetails.class)
    private MoneyDetails remainingOverdraftBalance;

    public OverdraftTransactionDetails() {
    }

    public FinancialTransactionId getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public Iso8601DateTime getCommitDate() {
        return this.commitDate;
    }

    public FRIValue getFromAccount() {
        return this.fromAccount;
    }

    public FRIValue getToAccount() {
        return this.toAccount;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public MoneyDetails getAccessFeeBalance() {
        return this.accessFeeBalance;
    }

    public MoneyDetails getInterestBalance() {
        return this.interestBalance;
    }

    public MoneyDetails getUsedOverdraftBalance() {
        return this.usedOverdraftBalance;
    }

    public MoneyDetails getRemainingOverdraftBalance() {
        return this.remainingOverdraftBalance;
    }

    public MoneyDetails getAccessFee() {
        return this.accessFee;
    }

    OverdraftTransactionDetails(Builder builder) {
        this.financialTransactionId = FinancialTransactionId.fromLong(builder.financialTransactionId);
        this.amount = builder.amount;
        this.commitDate = builder.commitDate;
        this.fromAccount = builder.fromAccount;
        this.toAccount = builder.toAccount;
        this.transferType = builder.transferType;
        this.accessFee = builder.accessFee;
        this.accessFeeBalance = builder.accessFeeBalance;
        this.interestBalance = builder.interestBalance;
        this.usedOverdraftBalance = builder.usedOverdraftBalance;
        this.remainingOverdraftBalance = builder.remainingOverdraftBalance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public static final class Builder {
        private Long financialTransactionId;
        private MoneyDetails amount;
        private Iso8601DateTime commitDate;
        private FRIValue fromAccount;
        private FRIValue toAccount;
        private TransferType transferType;
        private MoneyDetails accessFee;
        private MoneyDetails accessFeeBalance;
        private MoneyDetails interestBalance;
        private MoneyDetails usedOverdraftBalance;
        private MoneyDetails remainingOverdraftBalance;

        Builder() {
        }

        Builder(OverdraftTransactionDetails overdraftTransactionDetails) {
            this.financialTransactionId = overdraftTransactionDetails.financialTransactionId.getValueAsLong();
            this.amount = overdraftTransactionDetails.amount;
            this.commitDate = overdraftTransactionDetails.commitDate;
            this.fromAccount = overdraftTransactionDetails.fromAccount;
            this.toAccount = overdraftTransactionDetails.toAccount;
            this.transferType = overdraftTransactionDetails.transferType;
            this.accessFee = overdraftTransactionDetails.accessFee;
            this.accessFeeBalance = overdraftTransactionDetails.accessFeeBalance;
            this.interestBalance = overdraftTransactionDetails.interestBalance;
            this.usedOverdraftBalance = overdraftTransactionDetails.usedOverdraftBalance;
            this.remainingOverdraftBalance = overdraftTransactionDetails.remainingOverdraftBalance;
        }

        public Builder financialTransactionId(Long financialTransactionId) {
            this.financialTransactionId = financialTransactionId;
            return this;
        }

        public Builder amount(MoneyDetails amount) {
            this.amount = amount;
            return this;
        }

        public Builder commitDate(Iso8601DateTime commitDate) {
            this.commitDate = commitDate;
            return this;
        }

        public Builder fromAccount(FRIValue fromAccount) {
            this.fromAccount = fromAccount;
            return this;
        }

        public Builder toAccount(FRIValue toAccount) {
            this.toAccount = toAccount;
            return this;
        }

        public Builder transferType(TransferType transferType) {
            this.transferType = transferType;
            return this;
        }

        public Builder accessFee(MoneyDetails accessFee) {
            this.accessFee = accessFee;
            return this;
        }

        public Builder accessFeeBalance(MoneyDetails accessFeeBalance) {
            this.accessFeeBalance = accessFeeBalance;
            return this;
        }

        public Builder interestBalance(MoneyDetails interestBalance) {
            this.interestBalance = interestBalance;
            return this;
        }

        public Builder usedOverdraftBalance(MoneyDetails usedOverdraftBalance) {
            this.usedOverdraftBalance = usedOverdraftBalance;
            return this;
        }

        public Builder remainingOverdraftBalance(MoneyDetails remainingOverdraftBalance) {
            this.remainingOverdraftBalance = remainingOverdraftBalance;
            return this;
        }

        public OverdraftTransactionDetails build() {
            return Validation.validate(new OverdraftTransactionDetails(this));
        }
    }
}

